/*
 * Decompiled with CFR 0.152.
 */
package ordermate.services.sales;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.cache.LocalCacheListManager;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.inventory.combos.InventoryCombo;
import ordermate.database.inventory.combos.InventoryComboGroup;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.sales.SalesLineItem;

public final class UpgradeableComboHelper {
    private static final UpgradeableComboHelper instance = new UpgradeableComboHelper();
    private LocalCacheListManager<InventoryCombo> comboCache;

    public static final UpgradeableComboHelper getInstance() {
        return instance;
    }

    private UpgradeableComboHelper() {
        this.initialiseCache();
    }

    private void initialiseCache() {
        ObjectQuery query = Query.select(InventoryCombo.class).equals(InventoryCombo.Properties.UPGRADEABLE, (Object)"'1'", true).active(InventoryCombo.class).orderBy(InventoryCombo.Properties.SEQUENCE);
        this.comboCache = new LocalCacheListManager<InventoryCombo>(PersistenceManager.getComponentFactory().createQueryList(InventoryCombo.class, query));
    }

    public final boolean isUpgradeable(TriggerActivationContext context, SalesLineItem item) {
        if (context == null) {
            return false;
        }
        if (!item.getAccount().isOpen()) {
            return false;
        }
        if (!item.hasLoyaltyPointsAvailable()) {
            return false;
        }
        List<InventoryCombo> allUpgrades = this.comboCache.getList();
        for (InventoryCombo nextCombo : allUpgrades) {
            if (!nextCombo.isActive(context)) continue;
            for (InventoryComboGroup nextGroup : nextCombo.getGroups()) {
                if (!nextGroup.isMatchedItem(item)) continue;
                return true;
            }
        }
        return false;
    }

    public final List<InventoryCombo> getPotentialCombos(TriggerActivationContext context, SalesLineItem item) {
        List<InventoryCombo> allUpgrades = this.comboCache.getList();
        ArrayList<InventoryCombo> applicable = new ArrayList<InventoryCombo>();
        block0: for (InventoryCombo nextCombo : allUpgrades) {
            if (!nextCombo.isActive(context)) continue;
            for (InventoryComboGroup nextGroup : nextCombo.getGroups()) {
                if (!nextGroup.isMatchedItem(item)) continue;
                applicable.add(nextCombo);
                continue block0;
            }
        }
        return applicable;
    }
}

