/*
 * Decompiled with CFR 0.152.
 */
package ordermate.services.stock;

import au.com.ordermate.util.FinanceUtils;
import au.com.ordermate.util.Price;
import ordermate.database.config.Quantity;
import ordermate.database.misc.SystemProperty;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockItem;

public class StockCostCalculator {
    public static final double COST_PRICE_PRECISION = 1.0E-6;

    public static double getCostPerAtomicUnit(StockItem item, StockArea area) {
        Price onHandUnitCost = item.getCostOfStockOnHandIncTax(area);
        return StockCostCalculator.getAtomicUnitCost(item, onHandUnitCost);
    }

    public static Price getStockOnHandCost(StockItem item, StockArea area) {
        double atomicCost = StockCostCalculator.getCostPerAtomicUnit(item, area);
        Quantity stock = item.getStockOnHand(area);
        return new Price(atomicCost * stock.getRawValue(), 0.0);
    }

    public static Price getCostOfStockOnHandExTax(StockItem item, StockArea area) {
        Price incCost = item.getStockOnHandObject(area).getOnHandCostPerItem();
        if (item.isTaxIncluded()) {
            return FinanceUtils.removeTax(incCost, SystemProperty.getInstance().getBaseTaxRate());
        }
        return new Price(incCost, 0.0);
    }

    protected static double getAtomicUnitCost(StockItem item, Price unitCost) {
        double cost = unitCost.doubleValue();
        double qty = item.getPurchaseQty().getRawValue();
        return cost / qty;
    }
}

