/*
 * Decompiled with CFR 0.152.
 */
package ordermate.services.store;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.hardware.eftpos.EftposType;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.integration.cloudback.redback.RedBackClient;
import ordermate.services.store.StoreTaggerI;

public class StoreTagger
extends UnicastRemoteObject
implements StoreTaggerI {
    private static StoreTagger instance;
    private Map<String, Object> tags;

    public static StoreTagger getInstance() {
        if (instance == null) {
            try {
                instance = new StoreTagger();
            }
            catch (RemoteException ex) {
                OrderMate.LOG.warn("Can't make the Store Tagger", (Throwable)ex);
            }
        }
        return instance;
    }

    private StoreTagger() throws RemoteException {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    StoreTagger.this.refreshTags();
                }
                catch (RemoteException ex) {
                    OrderMate.LOG.error("Can't refresh the store tags", (Throwable)ex);
                }
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshTags() throws RemoteException {
        HashMap<String, Object> theTags = new HashMap<String, Object>();
        this.getEftpos(theTags);
        this.getCountry(theTags);
        this.getFromRedBack(theTags);
        StoreTagger storeTagger = this;
        synchronized (storeTagger) {
            this.tags = theTags;
        }
    }

    private void getEftpos(Map<String, Object> theTags) {
        List<VirtualEftpos> eftposes = PersistenceManager.getObjectList(VirtualEftpos.class, Query.select(VirtualEftpos.class).equals(VirtualEftpos.Properties.SYSTEM_STATE, SystemState.ACTIVE_STATE).toString());
        boolean hasTyro = false;
        boolean hasOolio = false;
        for (VirtualEftpos eft : eftposes) {
            if (EftposType.TYROWEB.equals(eft.getEftposType()) || EftposType.TYROMOBILE.equals(eft.getEftposType()) || EftposType.TYRO.equals(eft.getEftposType())) {
                hasTyro = true;
            }
            if (!EftposType.ADYEN.equals(eft.getEftposType())) continue;
            hasOolio = true;
        }
        theTags.put("has_tyro", hasTyro);
        theTags.put("has_oolio", hasOolio);
    }

    private void getCountry(Map<String, Object> theTags) {
        String country = Locale.getDefault().getCountry();
        theTags.put("country", country);
    }

    private void getFromRedBack(Map<String, Object> theTags) {
        Map<String, Object> rbTags = new RedBackClient().getStoreTags();
        if (!rbTags.isEmpty()) {
            for (Map.Entry<String, Object> nextTag : rbTags.entrySet()) {
                if (theTags.containsKey(nextTag.getKey())) continue;
                theTags.put(nextTag.getKey(), nextTag.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getTags() throws RemoteException {
        StoreTagger storeTagger = this;
        synchronized (storeTagger) {
            if (this.tags == null) {
                this.refreshTags();
            }
            return new HashMap<String, Object>(this.tags);
        }
    }
}

