/*
 * Decompiled with CFR 0.152.
 */
package ordermate.signals;

import au.com.ordermate.configuration.Config;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import ordermate.signals.Signal;

public abstract class AbstractSignal
implements Signal {
    public static final int ERROR_LEVEL_WARN = 0;
    public static final int ERROR_LEVEL_IGNORE = 1;
    public static final int ERROR_LEVEL_EXCEPTION = 2;
    public static final int ERROR_LEVEL_EXIT = 3;
    protected static final boolean LOG_EMITS = false;
    static int errorLevel = 0;
    protected transient ArrayList<Slot> slots = new ArrayList();
    protected Class[] paramClasses;

    protected abstract void emit(Object[] var1);

    @Override
    public abstract void connect(Object var1, String var2);

    @Override
    public void connect(Signal chainTo) {
        this.connect(chainTo, "emit");
    }

    protected void error(String message, Throwable e) {
        switch (errorLevel) {
            case 0: {
                Logger.getGlobal().log(Level.WARNING, message, e);
                break;
            }
            case 2: {
                throw new RuntimeException(message, e);
            }
            case 3: {
                Logger.getGlobal().log(Level.SEVERE, message, e);
                System.exit(-1);
                break;
            }
            case 1: {
                break;
            }
            default: {
                Logger.getGlobal().log(Level.SEVERE, message, e);
                System.exit(-1);
            }
        }
    }

    public static void setErrorLevel(int newLevel) {
        errorLevel = newLevel;
    }

    @Override
    public void emit() {
        Object[] params = new Object[]{};
        this.emit(params);
    }

    public void emit(Object param) {
        Object[] params = new Object[]{param};
        this.emit(params);
    }

    public void emit(Object param, Object param1) {
        Object[] params = new Object[]{param, param1};
        this.emit(params);
    }

    public void emit(Object param, Object param1, Object param2) {
        Object[] params = new Object[]{param, param1, param2};
        this.emit(params);
    }

    public void emit(Object param, Object param1, Object param2, Object param3) {
        Object[] params = new Object[]{param, param1, param2, param3};
        this.emit(params);
    }

    public void emit(Object param, Object param1, Object param2, Object param3, Object param4) {
        Object[] params = new Object[]{param, param1, param2, param3, param4};
        this.emit(params);
    }

    protected final Method findDeclaredMethod(String methodName, Class toSearch, Class[] findParams) throws NoSuchMethodException {
        try {
            return toSearch.getDeclaredMethod(methodName, findParams);
        }
        catch (NoSuchMethodException e) {
            if (findParams.length != 0) {
                Class[] newParams = new Class[findParams.length - 1];
                for (int i = 0; i < newParams.length; ++i) {
                    newParams[i] = findParams[i];
                }
                return this.findDeclaredMethod(methodName, toSearch, newParams);
            }
            throw new NoSuchMethodException(e.getMessage());
        }
    }

    protected final Method findMethod(String methodName, Class toSearch, Class[] findParams) throws NoSuchMethodException {
        try {
            return toSearch.getMethod(methodName, findParams);
        }
        catch (NoSuchMethodException e) {
            this.logFindMethod(methodName, toSearch, findParams, e);
            if (findParams.length != 0) {
                Class[] newParams = new Class[findParams.length - 1];
                for (int i = 0; i < newParams.length; ++i) {
                    newParams[i] = findParams[i];
                }
                return this.findMethod(methodName, toSearch, newParams);
            }
            for (Method method : toSearch.getMethods()) {
                if (!method.getName().equals(methodName)) continue;
                return method;
            }
            throw new NoSuchMethodException(e.getMessage());
        }
    }

    protected final boolean doParamsMatch(Class[] expected, Class[] actual) {
        if (expected.length >= actual.length) {
            if (expected.length != 0) {
                for (int i = 0; i < actual.length; ++i) {
                    if (actual[i] == null || expected[i].isAssignableFrom(actual[i])) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public synchronized void disconnect(Object receiver) {
        ArrayList<Slot> toRemove = new ArrayList<Slot>();
        for (Slot nextSlot : this.slots) {
            if (receiver != nextSlot.getOwner()) continue;
            toRemove.add(nextSlot);
        }
        this.slots.removeAll(toRemove);
    }

    protected void logFindMethod(String methodName, Class toSearch, Class[] findParams, NoSuchMethodException e) {
        if (Config.isConfigSetup() && Config.isDebuging()) {
            Logger.getGlobal().log(Level.FINE, "Could not find : " + methodName + " in " + toSearch.getName() + " with subset of params : " + Arrays.toString(findParams));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<Slot> it = this.slots.iterator();
        while (it.hasNext()) {
            if (sb.length() > 0) {
                sb.append("; ");
            }
            Slot slot = it.next();
            sb.append(slot.getSlotMethod().toString());
        }
        return sb.toString();
    }

    @Override
    public boolean isConnected() {
        return !this.slots.isEmpty();
    }

    @Override
    public void disconnectAll() {
        this.slots.clear();
    }

    @Override
    public boolean isConnected(Object receiver) {
        for (Slot slot : this.slots) {
            if (slot.getOwner() != receiver) continue;
            return true;
        }
        return false;
    }

    protected static class Slot {
        private Object owner;
        private Method slotMethod;
        private int numParams;

        public Object getOwner() {
            return this.owner;
        }

        public void setOwner(Object object) {
            this.owner = object;
        }

        public int getNumParams() {
            return this.numParams;
        }

        public Method getSlotMethod() {
            return this.slotMethod;
        }

        public void setNumParams(int i) {
            this.numParams = i;
        }

        public void setSlotMethod(Method method) {
            this.slotMethod = method;
        }
    }
}

