/*
 * Decompiled with CFR 0.152.
 */
package ordermate.signals;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import ordermate.OrderMate;
import ordermate.signals.AbstractSignal;
import ordermate.signals.Signal;

public class CremeSignal
extends AbstractSignal
implements Signal {
    public CremeSignal(Class[] params) {
        this.paramClasses = params;
    }

    @Override
    protected void emit(Object[] params) {
        if (params.length != this.paramClasses.length) {
            this.error("Cannot emit signal: Number of parameters do not match!\nExpecting " + this.paramClasses.length + " got " + params.length, new IllegalStateException());
        } else {
            Class[] emitParamTypes = new Class[params.length];
            for (int i = 0; i < emitParamTypes.length; ++i) {
                emitParamTypes[i] = params[i].getClass();
            }
            boolean valid = this.doParamsMatch(this.paramClasses, emitParamTypes);
            if (valid) {
                for (AbstractSignal.Slot element : this.slots) {
                    Object[] slotParams;
                    if (element.getNumParams() != params.length) {
                        slotParams = new Object[element.getNumParams()];
                        for (int i = 0; i < slotParams.length; ++i) {
                            slotParams[i] = params[i];
                        }
                    } else {
                        slotParams = params;
                    }
                    try {
                        element.getSlotMethod().invoke(element.getOwner(), slotParams);
                    }
                    catch (IllegalArgumentException e) {
                        OrderMate.LOG.error("There is a bug in the signal and slot library", (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        OrderMate.LOG.error("There is a bug in the signal and slot library", (Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        OrderMate.LOG.error("An error occurred in emit. Slot fired exception \n in thread " + Thread.currentThread().getName(), (Throwable)e);
                        OrderMate.LOG.error("Exception fired by slot was: ", e.getTargetException());
                    }
                }
            } else {
                this.error("Cannot emit signal: Types provided of parameters do not match signal param types!", new IllegalStateException());
            }
        }
    }

    @Override
    public void connect(Object receiver, String slot) {
        Method slotMethod = null;
        try {
            slotMethod = this.findMethod(slot, receiver.getClass(), this.paramClasses);
            Iterator it = this.slots.iterator();
            boolean found = false;
            while (it.hasNext() && !found) {
                AbstractSignal.Slot element = (AbstractSignal.Slot)it.next();
                if (receiver != element.getOwner() || !slotMethod.equals(element.getSlotMethod())) continue;
                found = true;
            }
            if (!found) {
                slotMethod.setAccessible(true);
                AbstractSignal.Slot theSlot = new AbstractSignal.Slot();
                theSlot.setNumParams(slotMethod.getParameterTypes().length);
                theSlot.setOwner(receiver);
                theSlot.setSlotMethod(slotMethod);
                this.slots.add(theSlot);
            } else {
                this.error("Cannot connect signal: StandardSignal is already connected to this slot!", new IllegalStateException());
            }
        }
        catch (NoSuchMethodException e) {
            this.error("Cannot connect signal: Cannot find slot " + slot, e);
        }
    }

    @Override
    public Signal create(Class[] params) {
        return new CremeSignal(params);
    }
}

