/*
 * Decompiled with CFR 0.152.
 */
package ordermate.signals;

import au.com.ordermate.configuration.Config;
import javax.swing.SwingUtilities;
import ordermate.OrderMate;
import ordermate.signals.ThreadLocalSignal;
import sun.awt.AppContext;
import sun.awt.SunToolkit;

public class StandardSignal
extends ThreadLocalSignal {
    private static AppContext appContext;

    public static void setAppContext(AppContext context) {
        appContext = context;
    }

    StandardSignal(Class[] params) {
        super(params);
    }

    @Override
    protected void emit(final Object[] params) {
        block8: {
            if (AppContext.getAppContext() == null || !SwingUtilities.isEventDispatchThread()) {
                try {
                    String callStack0 = null;
                    if (Config.isDebuging()) {
                        callStack0 = new Exception().getStackTrace()[2].toString();
                    }
                    final String callStack = callStack0;
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            if (callStack != null) {
                                OrderMate.LOG.debug("Calling swing emit from : " + callStack);
                            }
                            StandardSignal.super.emit(params);
                        }
                    };
                    if (AppContext.getAppContext() == null) {
                        if (appContext != null) {
                            Thread thread = new Thread(appContext.getThreadGroup(), runnable);
                            thread.start();
                        } else {
                            SunToolkit.createNewAppContext();
                            SwingUtilities.invokeAndWait(runnable);
                        }
                        break block8;
                    }
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Exception e) {
                    OrderMate.LOG.error("exception in signal", (Throwable)e);
                }
            } else {
                super.emit(params);
            }
        }
    }

    @Override
    public StandardSignal create(Class[] params) {
        return new StandardSignal(params);
    }
}

