/*
 * Decompiled with CFR 0.152.
 */
package ordermate.signals;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import ordermate.signals.AbstractSignal;

public class ThreadLocalSignal
extends AbstractSignal {
    public static final int ERROR_LEVEL_LOG = 4;

    public ThreadLocalSignal(Class[] params) {
        this.paramClasses = params;
    }

    @Override
    public ThreadLocalSignal create(Class[] params) {
        return new ThreadLocalSignal(params);
    }

    protected Class getCallingClass() {
        String us;
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        String caller = us = ThreadLocalSignal.class.getName();
        int i = 1;
        while (us.equals(caller)) {
            caller = stackTrace[i].getClassName();
            ++i;
        }
        Class<?> classType = null;
        try {
            classType = Class.forName(stackTrace[i - 1].getClassName());
        }
        catch (ClassNotFoundException e) {
            Logger.getGlobal().log(Level.WARNING, "Cannot find class given in stack trace!", e);
        }
        return classType;
    }

    protected String getCallingAddress() {
        String us;
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        String caller = us = ThreadLocalSignal.class.getName();
        StackTraceElement prevElement = null;
        StackTraceElement callElement = stackTrace[0];
        int i = 0;
        while (us.equals(caller)) {
            caller = stackTrace[i].getClassName();
            prevElement = callElement;
            callElement = stackTrace[i];
            ++i;
        }
        callElement = prevElement;
        String address = callElement.getClassName() + " " + callElement.getFileName() + ":" + callElement.getLineNumber();
        return address;
    }

    @Override
    protected void emit(Object[] params) {
        if (params.length != this.paramClasses.length) {
            this.error("Cannot emit signal at " + this.getCallingAddress() + " : Number of parameters do not match!\nExpecting " + this.paramClasses.length + " got " + params.length, new IllegalStateException());
        } else {
            Class[] emitParamTypes = new Class[params.length];
            for (int i = 0; i < emitParamTypes.length; ++i) {
                emitParamTypes[i] = params[i] == null ? null : params[i].getClass();
            }
            boolean valid = this.doParamsMatch(this.paramClasses, emitParamTypes);
            if (valid) {
                ArrayList safeList = new ArrayList(this.slots);
                for (AbstractSignal.Slot element : safeList) {
                    Object[] slotParams;
                    if (!this.slots.contains(element)) continue;
                    if (element.getNumParams() != params.length) {
                        slotParams = new Object[element.getNumParams()];
                        for (int i = 0; i < slotParams.length; ++i) {
                            slotParams[i] = params[i];
                        }
                    } else {
                        slotParams = params;
                    }
                    try {
                        element.getSlotMethod().invoke(element.getOwner(), slotParams);
                    }
                    catch (IllegalArgumentException e) {
                        Logger.getGlobal().log(Level.SEVERE, "There is a bug in the signal and slot library", e);
                    }
                    catch (IllegalAccessException e) {
                        Logger.getGlobal().log(Level.SEVERE, "There is a bug in the signal and slot library", e);
                    }
                    catch (InvocationTargetException e) {
                        Logger.getGlobal().log(Level.SEVERE, "An error occurred emit at " + this.getCallingAddress() + " slot fired exception " + e.getCause() + "\n in thread " + Thread.currentThread().getName(), e);
                    }
                }
            } else {
                this.error("Cannot emit signal at " + this.getCallingAddress() + " : Types of provided parameters do not match signal param types!", new IllegalStateException());
            }
        }
    }

    @Override
    public void connect(Object receiver, String slot) {
        Method slotMethod = null;
        try {
            Class clazz = this.getCallingClass();
            if (clazz != null && clazz.equals(receiver.getClass())) {
                try {
                    slotMethod = this.findDeclaredMethod(slot, receiver.getClass(), this.paramClasses);
                }
                catch (NoSuchMethodException e) {
                    slotMethod = this.findMethod(slot, receiver.getClass(), this.paramClasses);
                }
            } else {
                slotMethod = this.findMethod(slot, receiver.getClass(), this.paramClasses);
            }
        }
        catch (NoSuchMethodException e) {
            this.error("Cannot connect signal at " + this.getCallingAddress() + " : Cannot find slot " + slot + "!", e);
        }
        if (slotMethod != null) {
            Iterator it = this.slots.iterator();
            boolean found = false;
            while (it.hasNext() && !found) {
                AbstractSignal.Slot element = (AbstractSignal.Slot)it.next();
                if (receiver != element.getOwner() || !slotMethod.equals(element.getSlotMethod())) continue;
                found = true;
            }
            if (!found) {
                slotMethod.setAccessible(true);
                AbstractSignal.Slot theSlot = new AbstractSignal.Slot();
                theSlot.setNumParams(slotMethod.getParameterTypes().length);
                theSlot.setOwner(receiver);
                theSlot.setSlotMethod(slotMethod);
                this.slots.add(theSlot);
            } else {
                this.error("Cannot connect signal at " + this.getCallingAddress() + " : StandardSignal is already connected to this slot!", new IllegalStateException());
            }
        }
    }

    @Override
    protected void error(String message, Throwable e) {
        if (errorLevel == 4) {
            Logger.getGlobal().log(Level.SEVERE, message, e);
        } else {
            super.error(message, e);
        }
    }

    @Override
    protected void logFindMethod(String methodName, Class toSearch, Class[] findParams, NoSuchMethodException e) {
        Logger.getGlobal().log(Level.FINE, "Could not find : " + methodName + " in " + toSearch.getSimpleName() + " with params: " + Arrays.toString(findParams), e);
    }
}

