/*
 * Decompiled with CFR 0.152.
 */
package ordermate.startup;

import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.simplermi.SimpleRMI;
import java.net.InetAddress;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.startup.TerminalNotFoundException;

public abstract class AbstractSetupTerminalTask
extends AbstractTask {
    private String terminalType;

    public AbstractSetupTerminalTask(String type) {
        this.terminalType = type;
    }

    @Override
    public int getTotalSubTasks() {
        return 1;
    }

    @Override
    public String getName() {
        return "Checking Terminal";
    }

    protected abstract void setupServerMate() throws Exception;

    @Override
    protected void performTask() throws Exception {
        Terminal.setupLocalhost(this.terminalType);
        OrderMate.LOG.info("Setup localhost to be " + this.terminalType);
        this.setupServerMate();
        OrderMate.LOG.info("Servermate terminal setup");
        Terminal me = Terminal.getLocalHost();
        OrderMate.LOG.info("Checking localhost");
        if (me == null) {
            throw new TerminalNotFoundException((Task)this, "Terminal Not Found", "Terminal " + InetAddress.getLocalHost() + " for user '" + System.getProperty("user.name") + "' cannot be found in database.", new String[]{"Check this terminal is setup correctly in the administration backend."}, false);
        }
        if (me.getMenuCaching()) {
            OrderMate.LOG.info("Caching is ON");
        } else {
            OrderMate.LOG.info("Caching is OFF");
        }
        if (SimpleRMI.isInitialized()) {
            me.setRmiPort(SimpleRMI.getSharePort());
            me.save();
        }
        OrderMate.LOG.info("Terminal setup complete");
        this.emitProgress();
    }
}

