/*
 * Decompiled with CFR 0.152.
 */
package ordermate.startup;

import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import java.util.List;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.Camera;
import ordermate.database.misc.SystemProperty;
import ordermate.startup.OrderMateSetupException;

public class CameraSetupTask
extends AbstractTask {
    @Override
    public final int getTotalSubTasks() {
        return 1;
    }

    @Override
    public final String getName() {
        return "Setting up cameras";
    }

    @Override
    public final void performTask() throws Exception {
        if (SystemProperty.getInstance().isCctvEnabled()) {
            List<Camera> cameras = Terminal.getLocalHost().getConnectedCameras();
            for (Camera cam : cameras) {
                try {
                    cam.startup(Terminal.getLocalHost());
                }
                catch (Exception e) {
                    throw new OrderMateSetupException((Task)this, "Error starting camera " + cam.getLabel(), e.getMessage() + ".", (Throwable)e, false);
                }
            }
            Camera camAccess = Terminal.getLocalHost().getCCTVCamera();
            if (camAccess != null && camAccess.isTcpIp()) {
                try {
                    camAccess.startup(Terminal.getLocalHost());
                }
                catch (Exception e) {
                    throw new OrderMateSetupException((Task)this, "Error connecting to camera " + camAccess.getLabel(), e.getMessage() + ".", (Throwable)e, false);
                }
            }
        }
        this.emitProgress();
    }
}

