/*
 * Decompiled with CFR 0.152.
 */
package ordermate.startup;

import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.startup.DeviceNotFoundException;
import ordermate.startup.DeviceNotFoundExceptionType;
import ordermate.startup.StartupErrorManager;

public class CashdrawerSetupTask
extends AbstractTask {
    private StartupErrorManager errorManager;

    public CashdrawerSetupTask() {
        this(null);
    }

    public CashdrawerSetupTask(StartupErrorManager manager) {
        this.errorManager = manager;
    }

    @Override
    public final int getTotalSubTasks() {
        return 1;
    }

    @Override
    public final String getName() {
        return "Setting up Cashdrawers";
    }

    @Override
    protected final void performTask() throws Exception {
        DeviceNotFoundException deviceNotFoundEx = null;
        for (CashDrawer toStart : Terminal.getLocalHost().getConnectedCashDrawers()) {
            try {
                toStart.startup(Terminal.getLocalHost());
            }
            catch (Exception e) {
                deviceNotFoundEx = new DeviceNotFoundException((Task)this, "Error starting cash drawer " + toStart.getLabel(), e.getMessage() + ".", e, DeviceNotFoundExceptionType.CASHDRAWER, toStart);
                if (this.errorManager != null) {
                    this.errorManager.addDeviceNotFoundException(deviceNotFoundEx);
                    continue;
                }
                throw deviceNotFoundEx;
            }
        }
        if (deviceNotFoundEx != null) {
            throw deviceNotFoundEx;
        }
        this.emitProgress();
    }
}

