/*
 * Decompiled with CFR 0.152.
 */
package ordermate.startup;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.guicore.task.AbstractTask;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class ConfigureRMITask
extends AbstractTask {
    private List<String> allLocations = new ArrayList<String>();

    public ConfigureRMITask(String ... locations) {
        for (String nextLocation : locations) {
            this.addLocation(nextLocation);
        }
    }

    protected void addLocation(String value) {
        if (!this.allLocations.contains(value)) {
            this.allLocations.add(value);
        }
    }

    @Override
    public String getName() {
        return "Configuring RMI Codebase";
    }

    @Override
    protected void performTask() throws Exception {
        if (this.allLocations.size() == 0) {
            this.emitProgress();
            return;
        }
        try {
            BasicService service = (BasicService)ServiceManager.lookup((String)BasicService.class.getName());
            URL codebaseURL = service.getCodeBase();
            StringBuilder SB = new StringBuilder();
            for (String nextLocation : this.allLocations) {
                SB.append(codebaseURL).append(nextLocation).append(" ");
            }
            String codebase = SB.toString();
            OrderMateLog.LOG.info("Codebase URL :" + codebase);
            System.setProperty("java.rmi.server.codebase", codebase);
        }
        catch (UnavailableServiceException ex) {
            OrderMateLog.LOG.error("Cannot proceed, jnlp ServiceManager cannot lookup basic service.", (Throwable)ex);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(null, "The codebase has not been correctly set.\nYou will need to specify java.rmi.server.codebase=/XXX/codebase.");
                }
            });
        }
        this.emitProgress();
    }

    @Override
    protected int getTotalSubTasks() {
        return 1;
    }
}

