/*
 * Decompiled with CFR 0.152.
 */
package ordermate.startup;

import au.com.ordermate.guicore.task.AbstractTask;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import ordermate.OrderMate;
import org.apache.logging.log4j.core.Logger;

public class DeadlockLog
extends AbstractTask {
    private Logger deadlockLog;
    private String startupName;
    private long waitTime = 60000L;
    private static String INDENT = "    ";

    public DeadlockLog(String name) {
        this.startupName = name;
    }

    public void setWaitTime(long value) {
        if (value < 1L) {
            throw new IllegalArgumentException("Cannot set a zero or negative wait time.");
        }
        this.waitTime = value;
    }

    @Override
    public int getTotalSubTasks() {
        return 1;
    }

    @Override
    public String getName() {
        return this.startupName + " Deadlock Log Startup";
    }

    @Override
    protected void performTask() throws Exception {
        this.deadlockLog = OrderMate.LOG;
        Thread deadlockThread = new Thread((Runnable)new LogThread(), "Deadlock log thread");
        deadlockThread.start();
        this.emitProgress();
    }

    private class LogThread
    implements Runnable {
        private ThreadMXBean tmbean = ManagementFactory.getThreadMXBean();

        @Override
        public void run() {
            DeadlockLog.this.deadlockLog.info("Starting deadlock checker thread");
            while (true) {
                long[] tids;
                if ((tids = this.tmbean.findDeadlockedThreads()) != null) {
                    StringBuilder deadlockInfo = new StringBuilder("Deadlock found :");
                    ThreadInfo[] infos = this.tmbean.getThreadInfo(tids, true, true);
                    for (int i = 0; i < infos.length; ++i) {
                        ThreadInfo ti = infos[i];
                        this.printThreadInfo(ti, deadlockInfo);
                        this.printLockInfo(ti.getLockedSynchronizers(), deadlockInfo);
                        deadlockInfo.append('\n');
                    }
                    DeadlockLog.this.deadlockLog.fatal((CharSequence)deadlockInfo);
                }
                try {
                    Thread.sleep(DeadlockLog.this.waitTime);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        private void printThreadInfo(ThreadInfo ti, StringBuilder buffer) {
            this.printThread(ti, buffer);
            StackTraceElement[] stacktrace = ti.getStackTrace();
            MonitorInfo[] monitors = ti.getLockedMonitors();
            for (int i = 0; i < stacktrace.length; ++i) {
                StackTraceElement ste = stacktrace[i];
                buffer.append(INDENT + "at " + ste.toString() + '\n');
                for (int j = 0; j < monitors.length; ++j) {
                    MonitorInfo mi = monitors[j];
                    if (mi.getLockedStackDepth() != i) continue;
                    buffer.append(INDENT + "  - locked " + mi + '\n');
                }
            }
            buffer.append('\n');
        }

        private void printThread(ThreadInfo ti, StringBuilder buffer) {
            buffer.append("\"" + ti.getThreadName() + "\" Id=" + ti.getThreadId() + " in " + (Object)((Object)ti.getThreadState()));
            if (ti.getLockName() != null) {
                buffer.append(" on lock=" + ti.getLockName());
            }
            if (ti.isSuspended()) {
                buffer.append(" (suspended)");
            }
            if (ti.isInNative()) {
                buffer.append(" (running in native)");
            }
            buffer.append('\n');
            if (ti.getLockOwnerName() != null) {
                buffer.append(INDENT + " owned by " + ti.getLockOwnerName() + " Id=" + ti.getLockOwnerId() + '\n');
            }
        }

        private void printLockInfo(LockInfo[] locks, StringBuilder buffer) {
            buffer.append(INDENT + "Locked synchronizers: count = " + locks.length + '\n');
            for (int i = 0; i < locks.length; ++i) {
                LockInfo li = locks[i];
                buffer.append(INDENT + "  - " + li + '\n');
            }
            buffer.append('\n');
        }
    }
}

