/*
 * Decompiled with CFR 0.152.
 */
package ordermate.startup;

import au.com.ordermate.guicore.task.AbstractTask;
import java.util.Timer;
import java.util.TimerTask;
import ordermate.OrderMate;
import ordermate.database.misc.SystemProperty;
import ordermate.startup.DeviceNotFoundException;
import ordermate.startup.StartupErrorManager;

public class DeviceFailureStartupTask
extends AbstractTask {
    private final int DEFAULT_RETRY_INTERVAL = 30000;
    private final int START_DELAY = 30000;

    @Override
    public String getName() {
        return "Device Restart Task";
    }

    @Override
    protected void performTask() throws Exception {
        new Timer().schedule((TimerTask)new DeviceRestartTask(), 30000L, SystemProperty.getInstance().getDeviceFailureSecsBetweenAttempts() > 0 ? (long)Math.abs(SystemProperty.getInstance().getDeviceFailureSecsBetweenAttempts() * 1000) : 30000L);
        this.emitProgress();
    }

    @Override
    protected int getTotalSubTasks() {
        return 1;
    }

    private static final class DeviceRestartTask
    extends TimerTask {
        private DeviceRestartTask() {
        }

        @Override
        public void run() {
            OrderMate.LOG.info("DeviceRestartTask - Attempting to restart failed devices.");
            for (DeviceNotFoundException deviceEx : StartupErrorManager.getInstance().getDeviceNotFoundErrors()) {
                OrderMate.LOG.info("Attempting to restart device: " + deviceEx.getDevice().getLabel());
                if (StartupErrorManager.getInstance().retryDeviceNotFoundExceptionTask(deviceEx)) {
                    OrderMate.LOG.info("Successfully restarted device: " + deviceEx.getDevice().getLabel());
                    continue;
                }
                OrderMate.LOG.info("Failed to restart device: " + deviceEx.getDevice().getLabel());
            }
            if (StartupErrorManager.getInstance().getDeviceNotFoundErrors().isEmpty()) {
                OrderMate.LOG.info("DeviceRestartTask - No devices to restart, cancelling task.");
                this.cancel();
            }
        }
    }
}

