/*
 * Decompiled with CFR 0.152.
 */
package ordermate.startup;

import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.Device;
import ordermate.startup.DeviceNotFoundExceptionType;
import ordermate.startup.OrderMateSetupException;

public class DeviceNotFoundException
extends OrderMateSetupException {
    private DeviceNotFoundExceptionType deviceType;
    private Device device;
    private Task restartTask;
    private int attempedRestarts = 0;

    public DeviceNotFoundException(Task task, String head, String theIssue, Throwable cause, DeviceNotFoundExceptionType deviceType, Device device) {
        super(task, head, theIssue, cause, false);
        this.deviceType = deviceType;
        this.device = device;
        OrderMate.LOG.error(theIssue, cause);
    }

    public DeviceNotFoundExceptionType getDeviceType() {
        return this.deviceType;
    }

    public Device getDevice() {
        return this.device;
    }

    public Task getRetryTask() {
        if (this.restartTask == null) {
            this.restartTask = new DeviceRestartTask(this.device);
        }
        return this.restartTask;
    }

    public void incrementAttempts() {
        ++this.attempedRestarts;
    }

    public int getAttemptedRestarts() {
        return this.attempedRestarts;
    }

    private static final class DeviceRestartTask
    extends AbstractTask {
        private Device device;

        public DeviceRestartTask(Device device) {
            this.device = device;
            this.setRunOnce(false);
        }

        @Override
        public String getName() {
            return "Device Restart Task";
        }

        @Override
        protected void performTask() throws Exception {
            OrderMate.LOG.info("Starting " + this.device.getPortType() + " \"" + this.device.getLabel() + "\" at " + this.device.getPort());
            this.device.startup(Terminal.getLocalHost());
        }

        @Override
        protected int getTotalSubTasks() {
            return 1;
        }
    }
}

