/*
 * Decompiled with CFR 0.152.
 */
package ordermate.startup;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.simplermi.SimpleRMI;
import au.com.ordermate.util.IPAddressUtils;
import au.com.ordermate.util.ListUtils;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.startup.RMIStartupTask;
import ordermate.startup.UniqueTask;

public class DynamicPortRangeRMIStartupTask
extends RMIStartupTask {
    private final int basePort;
    private final int portOffset;
    private final String terminalType;
    private final Set<Integer> portSet;
    private UniqueTask postCheck;

    public DynamicPortRangeRMIStartupTask(int basePort, int portOffset, String terminalType, Set<Integer> portSet) {
        super(basePort);
        this.basePort = basePort;
        this.portOffset = portOffset;
        this.terminalType = terminalType;
        this.portSet = portSet;
    }

    public DynamicPortRangeRMIStartupTask setUniqueTask(UniqueTask uniqueCheck) {
        this.postCheck = uniqueCheck;
        return this;
    }

    @Override
    protected void performTask() throws Exception {
        this.adjustPorts();
        super.performTask();
        this.postCheck();
        this.savePort(SimpleRMI.getSharePort());
    }

    protected void postCheck() throws Exception {
        if (this.postCheck != null) {
            this.postCheck.runLocal();
        }
    }

    protected void savePort(int sharePort) {
        Terminal localhost = Terminal.getLocalHost();
        localhost.setRmiPort(sharePort);
        localhost.save();
    }

    protected void adjustPorts() {
        try {
            List<InetAddress> localAddresses = IPAddressUtils.getLocalAddresses();
            Map<String, Integer> allPorts = this.getTerminals(localAddresses);
            if (!allPorts.isEmpty()) {
                ArrayList<Integer> ports = new ArrayList<Integer>();
                for (int i = 0; i < allPorts.size() - 1; ++i) {
                    ports.add(this.basePort + this.portOffset + i);
                }
                if (!ports.contains(this.basePort)) {
                    ports.add(0, this.basePort);
                }
                this.rearrangeForKnownPorts(ports, allPorts);
                this.portSet.clear();
                this.portSet.addAll(ports);
                int[] intPorts = new int[ports.size()];
                for (int i = 0; i < ports.size(); ++i) {
                    intPorts[i] = (Integer)ports.get(i);
                }
                this.setPorts(intPorts);
            } else {
                OrderMate.LOG.error("No Terminal(s) found for IP addresses: " + ListUtils.listToString(localAddresses, ", ") + ", using default port(s):" + this.portSet);
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error occured dynamically assigning ports, using default port(s):" + this.portSet, (Throwable)ex);
        }
    }

    private void rearrangeForKnownPorts(List<Integer> ports, Map<String, Integer> allPorts) {
        String myName = this.getUsername();
        for (Map.Entry<String, Integer> entry : allPorts.entrySet()) {
            Integer port = entry.getValue();
            if (port == null || (myName != null || entry.getKey() == null) && (myName == null || myName.equals(entry.getKey()))) continue;
            ports.remove(port);
            ports.add(port);
        }
        Integer myLastPort = allPorts.get(myName);
        if (myLastPort != null) {
            ports.remove(myLastPort);
            ports.add(0, myLastPort);
        }
    }

    protected String getUsername() {
        return Terminal.getLocalHost().getUsername();
    }

    protected Map<String, Integer> getTerminals(List<InetAddress> localIpAddresses) throws Exception {
        ArrayList<String> ips = new ArrayList<String>(localIpAddresses.size());
        for (InetAddress address : localIpAddresses) {
            ips.add(address.getHostAddress());
        }
        ObjectQuery query = Query.select(Terminal.class).wherePropertyIn(Terminal.Properties.ADDRESS, ips).equals(Terminal.Properties.TERMINAL_TYPE, this.terminalType).active(Terminal.class);
        List<Terminal> terminals = PersistenceManager.getObjectList(Terminal.class, query.toString());
        HashMap<String, Integer> namePorts = new HashMap<String, Integer>();
        for (Terminal terminal : terminals) {
            namePorts.put(terminal.getUsername(), terminal.getRmiPort());
        }
        return namePorts;
    }
}

