/*
 * Decompiled with CFR 0.152.
 */
package ordermate.startup;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.persistence.PersistenceManager;
import ordermate.integration.humpy.HumpBackSync;
import ordermate.scheduler.Task;
import ordermate.services.misc.CallMethodOnClassExecutable;

public class HumpBackSyncUnknownsTask
implements Task {
    private static final String TASK_NAME = "Sync Unknown Items Task";

    @Override
    public void run() {
        OrderMateLog.LOG.info("Attempting to sync unknown items...");
        CallMethodOnClassExecutable exec = new CallMethodOnClassExecutable(HumpBackSync.class.getCanonicalName(), "getInstance", "performSync");
        Boolean result = (Boolean)PersistenceManager.getServerConnection().runSync(exec);
        if (result == null) {
            OrderMateLog.LOG.error("There was an error on Servermate, no syncing has taken place.");
        } else if (Boolean.FALSE.equals(result)) {
            OrderMateLog.LOG.error("There was an error synchronising and some unknowns may not be synced.");
        } else {
            OrderMateLog.LOG.info("Sync Successful! All resolved unknowns were synchronised.");
        }
    }

    @Override
    public String getName() {
        return TASK_NAME;
    }

    @Override
    public void setData(Object data) {
    }
}

