/*
 * Decompiled with CFR 0.152.
 */
package ordermate.startup;

import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import ordermate.OrderMate;
import ordermate.startup.OrderMateSetupException;

public class JavaVersionCheckSetupTask
extends AbstractTask {
    private final double desiredValue = 1.6;

    @Override
    public String getName() {
        return "Checking java version";
    }

    @Override
    public int getTotalSubTasks() {
        return 1;
    }

    @Override
    protected void performTask() throws Exception {
        String javaVersion = System.getProperties().getProperty("java.version");
        String versionPrefix = javaVersion.substring(0, 3);
        double versionValue = 0.0;
        try {
            versionValue = Double.parseDouble(versionPrefix);
        }
        catch (NumberFormatException ex) {
            OrderMate.LOG.error("Cannot figure out the java version.", (Throwable)ex);
        }
        OrderMate.LOG.info("Checking version of Java:" + versionValue);
        if (versionValue < 1.6) {
            throw new OrderMateSetupException((Task)this, "Java version not optimal.", "The java version (" + javaVersion + ") that the application is running under is not " + 1.6 + ".\nThis may result in less than optimal performance.", new String[]{"Download the latest version of java from: http://www.java.com/", "Contact ordermate support for assistance in downloading the latest java version."}, false);
        }
        this.emitProgress();
    }
}

