/*
 * Decompiled with CFR 0.152.
 */
package ordermate.startup;

import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.WindowsUtils;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.scheduler.Task;

public class LocalUserLogoutTask
implements Task {
    private static final String NAME = "Local User Logout";
    private static final String ADMINISTRATOR = "administrator";
    private static final String OMUSER = "omuser";

    @Override
    public void run() {
        String localUser = System.getProperty("user.name");
        for (Terminal terminal : Terminal.getAllTerminalsExceptServer()) {
            OrderMate.LOG.info("LocalUserLogoutTask :: Terminal : " + terminal.getName() + " UserName : " + terminal.getUsername() + " Local User : " + localUser);
            if (!LocalUserLogoutTask.shouldLogOut(terminal.getUsername(), localUser)) continue;
            try {
                OrderMate.LOG.info("Before Calling WindowsUtils.logOffUser " + terminal.getUsername());
                boolean result = WindowsUtils.logOffUser(terminal.getUsername());
                OrderMate.LOG.info("LocalUserLogoutTask :: result " + result);
            }
            catch (Exception ex) {
                OrderMate.LOG.warn("Couldn't auto-logoff user:" + terminal.getUsername(), (Throwable)ex);
            }
        }
    }

    static boolean shouldLogOut(String terminalUsername, String localUser) {
        boolean shouldLogOut = !StringUtils.isEmpty(terminalUsername);
        shouldLogOut = shouldLogOut && (StringUtils.isEmpty(localUser) || !localUser.equals(terminalUsername));
        shouldLogOut = shouldLogOut && !terminalUsername.equalsIgnoreCase(ADMINISTRATOR);
        shouldLogOut = shouldLogOut && !terminalUsername.equalsIgnoreCase(OMUSER);
        OrderMate.LOG.info("Should log out " + terminalUsername + "? " + shouldLogOut);
        return shouldLogOut;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void setData(Object data) {
    }
}

