/*
 * Decompiled with CFR 0.152.
 */
package ordermate.startup;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.guicore.task.AbstractTask;
import java.io.File;
import java.io.IOException;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.AppenderRefComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.LoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;

public class LoggerSetupTask
extends AbstractTask {
    private String logFile;
    protected String logRoot;
    private String pattern = "%d %p %c [%t] %m%n";
    private static final String STALE_SIZE = "100MB";
    private static final String STALE_AGE = "240D";
    private static final String STALE_COUNT = "1000";

    public LoggerSetupTask(String logFileName) {
        this.logFile = logFileName;
    }

    protected void setupLogRoot() {
        this.logRoot = System.getProperty("log.root") + File.separator + this.logFile;
    }

    @Override
    public final int getTotalSubTasks() {
        return 2;
    }

    @Override
    public final String getName() {
        return "Setting up print logging";
    }

    private void initializeLoggingContext() {
        System.setProperty("log4j2.formatMsgNoLookups", "true");
        System.setProperty("log4j2.asyncLoggerRingBufferSize", "1024");
        this.setupLogRoot();
        ConfigurationBuilder builder = ConfigurationBuilderFactory.newConfigurationBuilder();
        builder.setConfigurationName("OrderMate");
        String fileName = this.logRoot + "\\" + this.logFile + ".log";
        String filePattern = this.logRoot + "\\Older\\$${date:yyyy-MMMM-dd}\\" + this.logFile + "-%d{yyyy-MMMM-dd}-%i.log.gz";
        AppenderComponentBuilder appenderBuilder = (AppenderComponentBuilder)builder.newAppender("Stdout", "CONSOLE").addAttribute("target", (Enum)ConsoleAppender.Target.SYSTEM_OUT);
        appenderBuilder.add((LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", this.pattern));
        builder.add(appenderBuilder);
        LayoutComponentBuilder layoutBuilder = (LayoutComponentBuilder)builder.newLayout("PatternLayout").addAttribute("pattern", this.pattern);
        ComponentBuilder triggeringPolicy = builder.newComponent("Policies").addComponent(builder.newComponent("TimeBasedTriggeringPolicy").addAttribute("interval", "1").addAttribute("modulate", "false")).addComponent(builder.newComponent("SizeBasedTriggeringPolicy").addAttribute("size", "10MB"));
        ComponentBuilder rolloverStrategy = builder.newComponent("DefaultRolloverStrategy").addAttribute("max", 4).addAttribute("min", "1").addAttribute("fileIndex", "min").addAttribute("compressionLevel", "9").addComponent(this.createDeleteTag((ConfigurationBuilder<BuiltConfiguration>)builder));
        appenderBuilder = (AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)((AppenderComponentBuilder)builder.newAppender("RollingFileAppender", "RollingRandomAccessFile").addAttribute("fileName", fileName)).addAttribute("filePattern", filePattern)).addAttribute("bufferedIO", true)).addAttribute("immediateFlush", false)).addAttribute("append", "true")).add(layoutBuilder).addComponent(triggeringPolicy)).addComponent(rolloverStrategy);
        builder.add(appenderBuilder);
        AppenderRefComponentBuilder logFileRef = builder.newAppenderRef("RollingFileAppender");
        AppenderRefComponentBuilder stdoutRef = builder.newAppenderRef("Stdout");
        AppenderComponentBuilder asyncBuilder = builder.newAppender(this.logFile, "Async");
        asyncBuilder.addComponent((ComponentBuilder)logFileRef);
        asyncBuilder.addComponent((ComponentBuilder)stdoutRef);
        builder.add(asyncBuilder);
        builder.add((LoggerComponentBuilder)((LoggerComponentBuilder)builder.newLogger("testLog", Level.INFO).add(builder.newAppenderRef("RollingFileAppender"))).addAttribute("additivity", "false"));
        builder.add((RootLoggerComponentBuilder)((RootLoggerComponentBuilder)builder.newRootLogger(Level.INFO).addAttribute("includeLocation", "true")).add(builder.newAppenderRef(this.logFile)));
        LoggerContext context = Configurator.initialize((Configuration)((Configuration)builder.build()));
        context.getConfiguration();
    }

    private ComponentBuilder createDeleteTag(ConfigurationBuilder<BuiltConfiguration> builder) {
        ComponentBuilder accumulatedFileSize = builder.newComponent("IfAccumulatedFileSize").addAttribute("exceeds", STALE_SIZE);
        ComponentBuilder accumulatedFileCount = builder.newComponent("IfAccumulatedFileCount").addAttribute("exceeds", STALE_COUNT);
        ComponentBuilder ifLastModified = builder.newComponent("IfLastModified").addAttribute("age", STALE_AGE);
        ComponentBuilder ifAny = builder.newComponent("IfAny").addComponent(accumulatedFileSize).addComponent(accumulatedFileCount).addComponent(ifLastModified);
        ComponentBuilder ifFileName = builder.newComponent("IfFileName").addAttribute("glob", "**/" + this.logFile + "*.gz").addComponent(ifAny);
        ComponentBuilder deleteTag = builder.newComponent("Delete").addAttribute("basePath", this.logRoot).addAttribute("maxDepth", "5").addComponent(ifFileName);
        return deleteTag;
    }

    @Override
    protected final void performTask() throws Exception {
        this.createDirectoryIfNotExists();
        this.initializeLoggingContext();
        this.emitProgress();
        OrderMateLog.LOG = LoggerContext.getContext((boolean)false).getLogger(this.logFile);
    }

    private void createDirectoryIfNotExists() throws IOException {
        boolean success;
        String logRoot = System.getProperty("log.root");
        File dir = new File(logRoot);
        if (!dir.exists() && !(success = dir.mkdirs())) {
            throw new IOException("Could not create logging directory " + logRoot);
        }
    }
}

