/*
 * Decompiled with CFR 0.152.
 */
package ordermate.startup;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.simplermi.SimpleRMI;
import au.com.ordermate.util.ListUtils;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import ordermate.OrderMate;
import ordermate.misc.ServerMateRestClient;
import ordermate.startup.StartupManager;
import ordermate.startup.StartupManagerImpl;

public class ManagerStartupTask
extends AbstractTask {
    private String terminalType;
    private StartupManager manager;
    private List<String> servers;
    private static final int DEFAULT_MAX_TRIES = 60;
    private int maxTries;
    private static final int SERVERMATE_RMI_PORT = 11100;

    public ManagerStartupTask(String theTerminalType) {
        this(theTerminalType, null, 60);
    }

    public ManagerStartupTask(String type, List<String> serverIPs, int numTries) {
        this.terminalType = type;
        this.servers = serverIPs;
        this.maxTries = numTries;
    }

    @Override
    public String getName() {
        return "Starting the Startup Manager";
    }

    @Override
    public int getTotalSubTasks() {
        return 1;
    }

    @Override
    protected void performTask() {
        try {
            if (this.terminalType.equals("ServerMate")) {
                this.manager = StartupManagerImpl.getInstance();
                SimpleRMI.shareObject(this.manager, "Startup Manager");
            } else {
                if (this.servers == null || this.servers.isEmpty()) {
                    this.servers = Config.getStringListValue("app_server");
                    ArrayList<String> newServers = new ArrayList<String>();
                    for (String server : new ArrayList<String>(this.servers)) {
                        for (String newServer : ServerMateRestClient.getServerMateAddresses(server)) {
                            newServers.add(newServer);
                        }
                    }
                    for (String server : newServers) {
                        if (this.servers.contains(server)) continue;
                        this.servers.add(server);
                    }
                }
                OrderMate.LOG.info("Attempting to connect to ServerMate on " + this.servers.size() + " potential hosts (" + ListUtils.listToString(this.servers, ", ") + ")");
                int numTries = 0;
                while (this.manager == null && this.shouldRetry(numTries)) {
                    for (String server : this.servers) {
                        if (this.manager != null) continue;
                        OrderMate.LOG.info("Attempting connection to ServerMate startup manager on " + server);
                        try {
                            this.tryConnect(server);
                        }
                        catch (Exception e) {
                            this.handleRetryFailed(numTries, server, e);
                        }
                    }
                    ++numTries;
                }
            }
        }
        catch (Exception e) {
            OrderMate.LOG.error("Error occurred starting the Startup Manager", (Throwable)e);
        }
        this.doStartupSuccessful();
    }

    protected boolean shouldRetry(int currentTryCount) {
        return currentTryCount < this.maxTries;
    }

    protected void handleRetryFailed(int numTries, String server, Exception exception) throws InterruptedException {
        if (numTries != this.maxTries) {
            OrderMate.LOG.warn("Could not connect to the Startup Manager for " + server + " - will retry", (Throwable)exception);
            Thread.sleep(1000L);
        } else {
            OrderMate.LOG.error("Tried " + this.maxTries + " and could not connect to the Startup Manager for " + server, (Throwable)exception);
        }
    }

    protected void doStartupSuccessful() {
        this.emitProgress();
    }

    private void tryConnect(String server) throws Exception {
        InetAddress serverAddress = InetAddress.getByName(server);
        OrderMate.LOG.info("Server resolves to: " + serverAddress.toString());
        this.manager = (StartupManager)SimpleRMI.getObject(serverAddress, "Startup Manager", 11100);
        OrderMate.LOG.info("Status: " + this.manager.getStatus());
        this.startChecking();
    }

    private void startChecking() {
        boolean okToContinue = false;
        while (!okToContinue) {
            OrderMate.LOG.info("Checking ServerMate StartupManager for status...");
            try {
                String status = this.manager.getStatus();
                OrderMate.LOG.info("Got status: " + status);
                if (status.equals("ServerMate ready")) {
                    okToContinue = true;
                    this.sendStatus("Server ready");
                    continue;
                }
                this.sendStatus(status);
                Thread.sleep(2000L);
            }
            catch (Exception e) {
                OrderMate.LOG.error("Error running startup manager", (Throwable)e);
                this.sendStatus("Lost connection to server");
                okToContinue = true;
            }
        }
    }
}

