/*
 * Decompiled with CFR 0.152.
 */
package ordermate.startup;

import au.com.ordermate.guicore.task.AbstractTask;
import ordermate.OrderMate;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Logger;

public class MemoryLog
extends AbstractTask {
    private static final long DEFAULT_DELAY = 300000L;
    private static final int MEG = 0x100000;
    private Logger memoryLog;
    private String startupName;
    private final long delay;

    public MemoryLog(String name) {
        this(name, 300000L);
    }

    public MemoryLog(String name, long theDelay) {
        this.startupName = name;
        this.delay = theDelay > 0L ? theDelay : 300000L;
    }

    @Override
    public int getTotalSubTasks() {
        return 1;
    }

    @Override
    public String getName() {
        return this.startupName + " Memory Log Startup";
    }

    @Override
    protected void performTask() throws Exception {
        this.memoryLog = OrderMate.LOG;
        Thread memoryThread = new Thread((Runnable)new LogThread(), "Memory log thread");
        memoryThread.start();
        this.emitProgress();
    }

    private class LogThread
    implements Runnable {
        private LogThread() {
        }

        @Override
        public void run() {
            while (true) {
                Runtime runtime = Runtime.getRuntime();
                long totalMem = runtime.totalMemory();
                long usedMem = totalMem - runtime.freeMemory();
                long maxMem = runtime.maxMemory();
                maxMem /= 0x100000L;
                StringBuilder SB = new StringBuilder("Memory: ");
                SB.append("Used = ").append(usedMem /= 0x100000L).append(" MB. ");
                SB.append("Total = ").append(totalMem /= 0x100000L).append(" MB. ");
                SB.append("Max = ").append(maxMem).append(" MB. ");
                MemoryLog.this.memoryLog.log(Level.INFO, SB.toString());
                try {
                    Thread.sleep(MemoryLog.this.delay);
                    continue;
                }
                catch (InterruptedException e) {
                    OrderMate.LOG.error("Interrupted while waiting thread", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

