/*
 * Decompiled with CFR 0.152.
 */
package ordermate.startup;

import au.com.ordermate.guicore.task.Task;

public class OrderMateSetupException
extends RuntimeException {
    private String[] suggestions;
    private String issue;
    private Task taskFailed;
    private String heading;
    private boolean isFatal;
    private Throwable theCause;
    protected String prompt = "Continue Startup?";

    public OrderMateSetupException(Task task, String head, String theIssue, String[] someSuggestions, Throwable cause, boolean fatal) {
        super("Startup failed: " + (task != null ? task.getName() : "None specified"), cause);
        this.issue = theIssue;
        this.taskFailed = task;
        this.suggestions = someSuggestions;
        this.heading = head;
        this.isFatal = fatal;
        this.theCause = cause;
    }

    public OrderMateSetupException(Task task, String head, String theIssue, String[] someSuggestions, boolean fatal) {
        this(task, head, theIssue, someSuggestions, null, fatal);
    }

    public OrderMateSetupException(Task task, String theIssue, Throwable cause, boolean fatal) {
        this(task, null, theIssue, null, cause, fatal);
    }

    public OrderMateSetupException(Task task, String head, String[] someSuggestions, Throwable cause, boolean fatal) {
        this(task, head, null, someSuggestions, cause, fatal);
    }

    public OrderMateSetupException(Task task, String head, String[] someSuggestions, boolean fatal) {
        this(task, head, null, someSuggestions, null, fatal);
    }

    public OrderMateSetupException(Task task, String head, String theIssue, Throwable cause, boolean fatal) {
        this(task, head, theIssue, null, cause, fatal);
    }

    public String[] getSuggestions() {
        return this.suggestions;
    }

    public String getIssue() {
        return this.issue;
    }

    public String getHeading() {
        return this.heading;
    }

    public Task getFailedTask() {
        return this.taskFailed;
    }

    public String getHTMLMessage() {
        String message = "";
        message = message + "<html>";
        if (this.heading != null && this.heading.length() > 0) {
            message = message + "<h2>";
            message = message + this.heading;
            message = message + "</h2>";
        }
        if (this.issue != null && this.issue.length() > 0) {
            message = message + this.issue;
        }
        if (this.suggestions != null && this.suggestions.length > 0) {
            message = message + "<ul>";
            for (int i = 0; i < this.suggestions.length; ++i) {
                message = message + "<li>" + this.suggestions[i] + "</li>";
            }
            message = message + "</ul>";
        }
        if (!this.isFatal) {
            message = message + "<br>" + this.prompt;
        }
        message = message + "</html>";
        return message;
    }

    public String getStringMessage() {
        String message = "";
        if (this.heading != null && this.heading.length() > 0) {
            message = message + this.heading + "\n";
        }
        if (this.issue != null && this.issue.length() > 0) {
            message = message + this.issue.replace("\n", "<BR>") + "\n";
        }
        if (this.suggestions != null && this.suggestions.length > 0) {
            for (int i = 0; i < this.suggestions.length; ++i) {
                message = message + " - " + this.suggestions[i] + "\n";
            }
        }
        if (!this.isFatal) {
            message = message + this.prompt;
        }
        return message;
    }

    public boolean isFatal() {
        return this.isFatal;
    }

    public Throwable getTheCause() {
        return this.theCause;
    }

    public void setPrompt(String thePrompt) {
        this.prompt = thePrompt;
    }
}

