/*
 * Decompiled with CFR 0.152.
 */
package ordermate.startup;

import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import ordermate.OrderMate;
import ordermate.database.misc.TradingDay;
import ordermate.database.queries.misc.TradingDayQueries;
import ordermate.integration.piggy.NonRoomSalesExporter;
import ordermate.scheduler.Task;

public class PiggyPushNonRoomSalesTask
implements Task {
    public static final String NAME = "Daily Piggy Non Room Sales Push";
    public static final int MAX_RETRY_COUNT = 3;
    private static final Semaphore talkingStick = new Semaphore(1);
    private NonRoomSalesExporter exporter;
    private static final AtomicInteger failedRetryCount = new AtomicInteger(0);
    private static final long ONE_HOUR = 3600000L;
    private Timer timer;

    private void createTimer() {
        this.timer = new Timer("Sync User Updates Timer");
        failedRetryCount.set(0);
        OrderMate.LOG.info("Sync User Updates Timer is started.");
    }

    private void scheduleTimerTask(TimerTask task, long delay) {
        try {
            if (this.timer == null) {
                OrderMate.LOG.info("Starting Sync User Updates Timer.");
                this.createTimer();
            }
            this.timer.schedule(task, delay);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("failed to schedule the timer task! Due to: " + ex.getMessage() + " A new Timer will be created.", (Throwable)ex);
            if (this.timer != null) {
                this.timer.cancel();
                this.timer.purge();
            }
            this.createTimer();
            this.timer.schedule(task, delay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendNonRoomSales() throws Exception {
        try {
            this.exporter = new NonRoomSalesExporter();
            if (!this.canRun()) {
                return;
            }
            OrderMate.LOG.info("Performing Non Room Account Sales Push.");
            boolean isSuccessful = false;
            Date lastPushDate = this.exporter.getPiggyConfig().getLastPushDate();
            Date lastClosedTradingDay = TradingDayQueries.getLastClosedTradingDay().getDate();
            TradingDay currentTradingDay = TradingDay.getCurrentTradingDay();
            OrderMate.LOG.info("LastNon-RoomSalesPush Date = " + lastPushDate + " currentTradingDay = " + currentTradingDay + " lastClosedTradingDay = " + lastClosedTradingDay);
            if (lastPushDate == null) {
                isSuccessful = this.exporter.performExport(null);
            } else {
                if (lastPushDate.getTime() >= lastClosedTradingDay.getTime()) {
                    OrderMate.LOG.info("All Non-Room Sales in previous closed trading days have been pushed to Piggy Back.");
                    return;
                }
                OrderMate.LOG.info("Splitting Non Room Account Sales Push into days");
                List<TradingDay> tradingDays = TradingDayQueries.getClosedTradingDaysExStartIncEnd(lastPushDate, currentTradingDay.getDate());
                OrderMate.LOG.info("Pushing RMS Non-Room Sales for trading days " + tradingDays);
                for (TradingDay tday : tradingDays) {
                    isSuccessful = this.exporter.performExport(tday.getDate());
                    if (isSuccessful) continue;
                    OrderMate.LOG.info("Terminating push non room account sales prematurely.");
                    break;
                }
                OrderMate.LOG.info("Push Piggy Non Room Sales Finished");
            }
            if (!isSuccessful) {
                throw new Exception("Failed to push Piggy non-room sales");
            }
        }
        finally {
            talkingStick.release();
        }
    }

    @Override
    public void run() {
        block2: {
            try {
                this.sendNonRoomSales();
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Problem Push non-room sales to PiggyBack.", (Throwable)ex);
                if (failedRetryCount.get() != 0) break block2;
                OrderMate.LOG.error("The faild message(s) will be resent in 1 minute.");
                this.scheduleTimerTask(new ResendTask(), 60000L);
                failedRetryCount.incrementAndGet();
            }
        }
    }

    public boolean canRun() {
        boolean canRun = true;
        if (this.exporter == null) {
            OrderMate.LOG.info("Not exporting sales, not configured");
            canRun = false;
        } else if (!this.exporter.canExport()) {
            OrderMate.LOG.info("Not exporting sales, Piggy Back is disabled");
            canRun = false;
        }
        boolean isAcquired = talkingStick.tryAcquire();
        if (!isAcquired) {
            OrderMate.LOG.info("Talking Stick was still held from last time. Cannot push data to Piggy Back.");
            canRun = false;
        }
        return canRun;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void setData(Object data) {
    }

    class ResendTask
    extends TimerTask {
        ResendTask() {
        }

        @Override
        public void run() {
            try {
                PiggyPushNonRoomSalesTask.this.sendNonRoomSales();
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Problem while resending Piggy non-room sales", (Throwable)ex);
                if (failedRetryCount.get() >= 3) {
                    OrderMate.LOG.info("Retried for too many times, will give up RetryCount(" + failedRetryCount.get() + ")");
                    failedRetryCount.set(0);
                    return;
                }
                OrderMate.LOG.info("Failed massages will be resent in 1 hour. RetryCount(" + failedRetryCount.get() + ")");
                PiggyPushNonRoomSalesTask.this.scheduleTimerTask(new ResendTask(), 3600000L);
                failedRetryCount.incrementAndGet();
            }
        }
    }
}

