/*
 * Decompiled with CFR 0.152.
 */
package ordermate.startup;

import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.docket.DocketTemplate;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.PhysicalPrinter;
import ordermate.dockets.groovy.DiscardDocket;
import ordermate.startup.DeviceNotFoundException;
import ordermate.startup.DeviceNotFoundExceptionType;
import ordermate.startup.StartupErrorManager;

public class PrinterSetupTask
extends AbstractTask {
    private StartupErrorManager errorManager;

    public PrinterSetupTask() {
        this(null);
    }

    public PrinterSetupTask(StartupErrorManager manager) {
        this.errorManager = manager;
    }

    @Override
    public final int getTotalSubTasks() {
        return 1;
    }

    @Override
    public final String getName() {
        return "Setting up printers";
    }

    @Override
    protected final void performTask() throws Exception {
        Terminal localTerminal = Terminal.getLocalHost();
        List<PhysicalPrinter> printers = localTerminal.getConnectedPrinters();
        for (PhysicalPrinter printer : printers) {
            StartPrinterTask startPrinterTask = new StartPrinterTask(printer);
            Thread printerStartThread = new Thread((Runnable)startPrinterTask, "Start_Printer_" + printer.getLabel());
            printerStartThread.start();
        }
        this.emitProgress();
    }

    private class StartPrinterTask
    implements Runnable {
        final PhysicalPrinter printer;
        DeviceNotFoundException notFoundEx = null;

        public StartPrinterTask(PhysicalPrinter physicalPrinter) {
            this.printer = physicalPrinter;
        }

        @Override
        public void run() {
            OrderMate.LOG.info("Starting " + this.printer.getPortType() + " printer \"" + this.printer.getLabel() + "\" at " + this.printer.getPort());
            try {
                DocketTemplate.class.getName();
                DiscardDocket.class.getName();
            }
            catch (Exception ex) {
                OrderMate.LOG.warn("Exception loading docket classes", (Throwable)ex);
            }
            try {
                this.printer.startup(Terminal.getLocalHost());
            }
            catch (Exception e) {
                this.notFoundEx = new DeviceNotFoundException((Task)PrinterSetupTask.this, "Error starting printer " + this.printer.getLabel(), e.getMessage() + ".", e, DeviceNotFoundExceptionType.PRINTER, this.printer);
                if (PrinterSetupTask.this.errorManager != null) {
                    PrinterSetupTask.this.errorManager.addDeviceNotFoundException(this.notFoundEx);
                }
                throw this.notFoundEx;
            }
        }
    }
}

