/*
 * Decompiled with CFR 0.152.
 */
package ordermate.startup;

import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import ordermate.OrderMate;
import ordermate.database.misc.TradingDay;
import ordermate.database.queries.misc.TradingDayQueries;
import ordermate.integration.diamondback.DiamondSummaryReportExporter;
import ordermate.scheduler.Task;

public class PushDiamondSummaryReportTask
implements Task {
    public static final String NAME = "Diamond Summary Report Push";
    public static final int MAX_RETRY_COUNT = 3;
    private static final Semaphore talkingStick = new Semaphore(1);
    private DiamondSummaryReportExporter exporter;
    private static final AtomicInteger failedRetryCount = new AtomicInteger(0);
    private static final long ONE_HOUR = 3600000L;
    private Timer timer;

    private void createTimer() {
        this.timer = new Timer("Reports Resend Timer");
        failedRetryCount.set(0);
        OrderMate.LOG.info("Reports Resend Timer is started.");
    }

    private void scheduleTimerTask(TimerTask task, long delay) {
        try {
            if (this.timer == null) {
                OrderMate.LOG.info("Starting Reports Resend Timer Timer.");
                this.createTimer();
            }
            this.timer.schedule(task, delay);
        }
        catch (Exception ex) {
            OrderMate.LOG.error("failed to schedule the timer task! Due to: " + ex.getMessage() + " A new Timer will be created.", (Throwable)ex);
            if (this.timer != null) {
                this.timer.cancel();
                this.timer.purge();
            }
            this.createTimer();
            this.timer.schedule(task, delay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendDiamondSummaryReport() throws Exception {
        try {
            this.exporter = new DiamondSummaryReportExporter();
            if (!this.canRun()) {
                return;
            }
            OrderMate.LOG.info("Performing Diamond Summary Report Push.");
            boolean isSuccessful = false;
            Date lastPushDate = this.exporter.getDiamondReportConfig().getLastPushDate();
            Date lastClosedTradingDay = TradingDayQueries.getLastClosedTradingDay().getDate();
            TradingDay currentTradingDay = TradingDay.getCurrentTradingDay();
            OrderMate.LOG.info("Last Diamond Report Push Date = " + lastPushDate + " currentTradingDay = " + currentTradingDay + " lastClosedTradingDay = " + lastClosedTradingDay);
            if (lastPushDate == null) {
                isSuccessful = this.exporter.performExport(null);
            } else {
                if (lastPushDate.getTime() >= lastClosedTradingDay.getTime()) {
                    OrderMate.LOG.info("All Diamond Summary Report in previous closed trading days have been pushed to DiamondBack.");
                    return;
                }
                OrderMate.LOG.info("Splitting Diamond Summary Report Push into days");
                List<TradingDay> tradingDays = TradingDayQueries.getClosedTradingDaysExStartIncEnd(lastPushDate, currentTradingDay.getDate());
                OrderMate.LOG.info("Pushing Diamond Summary Report for trading days " + tradingDays);
                for (TradingDay tday : tradingDays) {
                    isSuccessful = this.exporter.performExport(tday.getDate());
                    if (isSuccessful) continue;
                    OrderMate.LOG.info("Terminating push Diamond Summary Report prematurely.");
                    break;
                }
                OrderMate.LOG.info("Push Diamond Summary Report Finished");
            }
            if (!isSuccessful) {
                throw new Exception("Failed to push Diamond Summary Report");
            }
        }
        finally {
            talkingStick.release();
        }
    }

    @Override
    public void run() {
        block2: {
            try {
                this.sendDiamondSummaryReport();
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Problem Push Diamond Summary Report to DiamondBack.", (Throwable)ex);
                if (failedRetryCount.get() != 0) break block2;
                OrderMate.LOG.error("The faild message(s) will be resent in 1 minute.");
                this.scheduleTimerTask(new ResendTask(), 60000L);
                failedRetryCount.incrementAndGet();
            }
        }
    }

    public boolean canRun() {
        if (this.exporter == null) {
            OrderMate.LOG.info("Not exporting report, not configured");
            return false;
        }
        if (!this.exporter.canExport()) {
            OrderMate.LOG.info("Not exporting report, DiamondBack Report is disabled");
            return false;
        }
        boolean isAcquired = talkingStick.tryAcquire();
        if (!isAcquired) {
            OrderMate.LOG.info("Talking Stick was still held from last time. Cannot push data to Piggy Back.");
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void setData(Object data) {
    }

    class ResendTask
    extends TimerTask {
        ResendTask() {
        }

        @Override
        public void run() {
            try {
                PushDiamondSummaryReportTask.this.sendDiamondSummaryReport();
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Problem while resending Diamond Summary Report", (Throwable)ex);
                if (failedRetryCount.get() >= 3) {
                    OrderMate.LOG.info("Retried for too many times, will give up RetryCount(" + failedRetryCount.get() + ")");
                    failedRetryCount.set(0);
                    return;
                }
                OrderMate.LOG.info("Failed massages will be resent in 1 hour. RetryCount(" + failedRetryCount.get() + ")");
                PushDiamondSummaryReportTask.this.scheduleTimerTask(new ResendTask(), 3600000L);
                failedRetryCount.incrementAndGet();
            }
        }
    }
}

