/*
 * Decompiled with CFR 0.152.
 */
package ordermate.startup;

import au.com.ordermate.util.WindowsUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import ordermate.scheduler.InvalidRebootTask;
import ordermate.services.reboot.RebootTerminalCallable;
import ordermate.services.reboot.RebootTerminalExecutable;
import ordermate.services.reboot.RebootTerminalRetriableTask;

public class RestartTerminalsTask
implements InvalidRebootTask {
    @Override
    public String getName() {
        return "Reboot Terminals Task";
    }

    @Override
    public void run() {
        ArrayList<RebootTerminalRetriableTask> toReboot = new ArrayList<RebootTerminalRetriableTask>();
        toReboot.addAll(this.getWaiterMateTerminalsToReboot());
        toReboot.addAll(this.getKTSToReboot());
        this.reboot(toReboot);
    }

    @Override
    public void setData(Object data) {
    }

    private List<RebootTerminalRetriableTask> getWaiterMateTerminalsToReboot() {
        HashSet<Terminal> waiterMateTerminals = new HashSet<Terminal>(Terminal.getAllWaiterMateTerminals());
        String serverMateIp = Terminal.getServerMateTerminal().getIPAddress();
        ArrayList<RebootTerminalRetriableTask> retriableTasks = new ArrayList<RebootTerminalRetriableTask>();
        for (Terminal wmTerminal : waiterMateTerminals) {
            if (serverMateIp.equals(wmTerminal.getIPAddress())) {
                try {
                    WindowsUtils.logOffUser(wmTerminal.getUsername());
                }
                catch (Exception ex) {
                    OrderMate.LOG.warn("Couldn't auto-logoff user:" + wmTerminal.getUsername());
                }
                continue;
            }
            RebootTerminalRetriableTask retriable = new RebootTerminalRetriableTask(new RebootTerminalCallable(wmTerminal));
            retriableTasks.add(retriable);
        }
        return retriableTasks;
    }

    private List<RebootTerminalRetriableTask> getKTSToReboot() {
        HashSet<KTSDocketPrinter> ktsTerminals = new HashSet<KTSDocketPrinter>(KTSDocketPrinter.getAllActiveKTSDocketPrinters());
        String serverMateIp = Terminal.getServerMateTerminal().getIPAddress();
        ArrayList<RebootTerminalRetriableTask> retriableTasks = new ArrayList<RebootTerminalRetriableTask>();
        for (KTSDocketPrinter kts : ktsTerminals) {
            if (serverMateIp.equals(kts.getIpAddress())) continue;
            RebootTerminalRetriableTask retriable = new RebootTerminalRetriableTask(new RebootTerminalCallable(kts));
            retriableTasks.add(retriable);
        }
        return retriableTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reboot(List<RebootTerminalRetriableTask> callables) {
        ExecutorService service = Executors.newFixedThreadPool(callables.size());
        try {
            List<Future<String>> futures = service.invokeAll(callables);
            this.logResults(futures);
        }
        catch (InterruptedException e) {
            OrderMate.LOG.error("Failed to execute reboot of terminals!", (Throwable)e);
        }
        finally {
            this.rebootServerMate();
        }
    }

    private void logResults(List<Future<String>> futures) {
        for (Future<String> future : futures) {
            try {
                OrderMate.LOG.info(future.get());
            }
            catch (Exception e) {
                OrderMate.LOG.error((Object)e);
            }
        }
    }

    private void rebootServerMate() {
        Terminal thisTerminal = Terminal.getServerMateTerminal();
        RebootTerminalExecutable exe = new RebootTerminalExecutable(thisTerminal, "ServerMate terminal is scheduled to be rebooted.");
        exe.execute();
    }
}

