/*
 * Decompiled with CFR 0.152.
 */
package ordermate.startup;

import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.Semaphore;
import ordermate.OrderMate;
import ordermate.database.integration.exportsales.ExportSalesHelper;
import ordermate.database.integration.exportsales.ExportSalesIntegration;
import ordermate.database.integration.exportsales.SalesExporterType;
import ordermate.database.misc.TradingDay;
import ordermate.integration.salesexport.AbstractSalesExporter;
import ordermate.integration.salesexport.DeputyExporter;
import ordermate.integration.salesexport.TandaExporter;
import ordermate.scheduler.Task;

public class SalesExportTask
implements Task {
    public static final String NAME = "Sales Export";
    private static final Semaphore talkingStick = new Semaphore(1);
    private AbstractSalesExporter exporter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ExportSalesIntegration integration = ExportSalesHelper.getIntegration();
        this.exporter = this.createExporter(integration);
        if (!this.canRun()) {
            return;
        }
        OrderMate.LOG.info("Performing Sales Export with " + (Object)((Object)integration.getExporterType()));
        try {
            Date fromDate = integration.getLastSalesExport();
            if (fromDate == null) {
                fromDate = TradingDay.getCurrentTradingDay().getDate();
            }
            long endTime = this.getEndTime();
            if (fromDate != null && endTime - fromDate.getTime() > 86400000L) {
                OrderMate.LOG.info("Experimental Feature: Splitting sales export into days");
                Calendar cal = Calendar.getInstance();
                cal.setTime(fromDate);
                cal.add(5, 1);
                cal.set(14, 0);
                while (cal.getTimeInMillis() < endTime) {
                    if (cal.getTimeInMillis() > endTime) {
                        this.exporter.performExport(true, null, null);
                        continue;
                    }
                    OrderMate.LOG.info("Performing Sales Export for " + fromDate + " to " + cal.getTime());
                    if (!this.exporter.performExport(true, fromDate, cal.getTime())) {
                        OrderMate.LOG.info("Terminating sales export prematurely.");
                        break;
                    }
                    fromDate = this.exporter.getIntegration().getLastSalesExport();
                    cal.setTime(fromDate);
                    cal.add(5, 1);
                }
            } else {
                this.exporter.performExport(true, null, null);
            }
            OrderMate.LOG.info("Sales Export Finished");
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error with sales export", (Throwable)ex);
        }
        finally {
            talkingStick.release();
        }
    }

    protected long getEndTime() {
        return System.currentTimeMillis();
    }

    protected AbstractSalesExporter createExporter(ExportSalesIntegration integration) {
        if (SalesExporterType.Deputy.equals((Object)integration.getExporterType())) {
            this.exporter = new DeputyExporter(integration);
        } else if (SalesExporterType.Tanda.equals((Object)integration.getExporterType())) {
            this.exporter = new TandaExporter(integration);
        }
        return this.exporter;
    }

    public boolean canRun() {
        boolean canRun = true;
        if (this.exporter == null) {
            OrderMate.LOG.info("Not exporting sales, not configured");
            canRun = false;
        } else if (!this.exporter.getIntegration().isEnabled()) {
            OrderMate.LOG.info("Not exporting to " + (Object)((Object)this.exporter.getIntegration().getExporterType()) + ", not enabled");
            canRun = false;
        } else if (!this.exporter.canExport()) {
            canRun = false;
        } else if (!talkingStick.tryAcquire()) {
            OrderMate.LOG.info("Talking Stick was still held from last time. Cannot export.");
            canRun = false;
        }
        return canRun;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void setData(Object data) {
    }
}

