/*
 * Decompiled with CFR 0.152.
 */
package ordermate.startup;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.persistence.cache.CacheManager;
import au.com.ordermate.sql.MySQLDialect;
import au.com.ordermate.sql.SQL;
import java.net.InetAddress;
import java.util.List;
import javax.swing.SwingUtilities;
import ordermate.OrderMate;
import ordermate.ServerConnectionManagerI;
import ordermate.serverconnection.ConnectionCheckThread;
import ordermate.serverconnection.ConnectionManagerScreen;
import ordermate.serverconnection.ServerConnectionManager;
import ordermate.startup.OrderMateSetupException;
import ordermate.startup.ServerConnectionErrorHandler;
import ordermate.startup.TerminalNotFoundException;

public class ServerConnectionSetupTask
extends AbstractTask {
    private Class screenClass;
    private List<String> servers;
    private String terminalType;
    private ServerConnectionErrorHandler errorHandler;
    private Runnable reconnectionTask;
    private ConnectionManagerScreen screen = null;
    private boolean registerRemoteCache = true;

    public ServerConnectionSetupTask() {
    }

    public ServerConnectionSetupTask(Class newScreen, String newTerminalType) {
        this.screenClass = newScreen;
        this.terminalType = newTerminalType;
    }

    public ServerConnectionSetupTask(Class newScreen, String newTerminalType, boolean registerRemoteCache) {
        this.screenClass = newScreen;
        this.terminalType = newTerminalType;
        this.registerRemoteCache = registerRemoteCache;
    }

    public ServerConnectionSetupTask(Class newScreen, String newTerminalType, Runnable reconnectRunnableTask) {
        this.screenClass = newScreen;
        this.terminalType = newTerminalType;
        this.reconnectionTask = reconnectRunnableTask;
    }

    public ServerConnectionSetupTask(Class newScreen, List<String> newServers, ServerConnectionErrorHandler handler, String newTerminalType, Runnable reconnectRunnableTask) {
        this.screenClass = newScreen;
        this.servers = newServers;
        this.errorHandler = handler;
        this.terminalType = newTerminalType;
        this.reconnectionTask = reconnectRunnableTask;
    }

    public void setScreen(ConnectionManagerScreen yourScreen) {
        this.screen = yourScreen;
    }

    @Override
    public int getTotalSubTasks() {
        return 2;
    }

    @Override
    public String getName() {
        return "Startup connection to server";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void performTask() throws Exception {
        if (this.servers == null) {
            this.servers = Config.getStringListValue("app_server");
        }
        Class<SQL> clazz = SQL.class;
        synchronized (SQL.class) {
            ServerConnectionManagerI.ServerConnectionStatus result;
            ConnectionCheckThread checkThread;
            if (!SQL.hasDialect()) {
                SQL.setDialect(new MySQLDialect());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (this.screen == null) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        if (ServerConnectionSetupTask.this.screenClass != null) {
                            try {
                                ServerConnectionSetupTask.this.screen = (ConnectionManagerScreen)ServerConnectionSetupTask.this.screenClass.newInstance();
                            }
                            catch (Exception ex) {
                                OrderMate.LOG.error("Error creating connection screen " + ServerConnectionSetupTask.this.screenClass, (Throwable)ex);
                            }
                        }
                    }
                });
            }
            if (!CacheManager.isInitialized()) {
                CacheManager.initialize(11100);
            }
            ServerConnectionManager manager = !ServerConnectionManager.isSetup() ? ServerConnectionManager.setupInstance(this.servers, this.screen, this.terminalType, this.reconnectionTask) : ServerConnectionManager.getInstance();
            manager.setRegisterRemoteCache(this.registerRemoteCache);
            Thread thread = null;
            if (!ConnectionCheckThread.isSetup()) {
                checkThread = ConnectionCheckThread.setupInstance(manager);
                thread = new Thread((Runnable)checkThread, "Server Connection KeepAlive");
                this.emitProgress();
            } else {
                checkThread = ConnectionCheckThread.getInstance();
            }
            if (thread != null) {
                thread.start();
                checkThread.setRunningThread(thread);
            }
            if ((result = manager.tryConnect()) == ServerConnectionManagerI.ServerConnectionStatus.NetworkError) {
                if (this.errorHandler == null) throw new OrderMateSetupException((Task)this, "Network Error", "Cannot access the ServerMate terminal.", new String[]{"Check the network is plugged in.", "Check the server terminal is switched on."}, true);
                this.errorHandler.networkError();
            } else if (result == ServerConnectionManagerI.ServerConnectionStatus.NoServermate) {
                if (this.errorHandler != null) {
                    this.errorHandler.noServerMate();
                }
            } else if (result == ServerConnectionManagerI.ServerConnectionStatus.NoTerminal) {
                if (this.errorHandler == null) throw new TerminalNotFoundException((Task)this, "Terminal Not Found", "Terminal " + InetAddress.getLocalHost() + " cannot be found in database.", new String[]{"Check this terminal is setup correctly in the administration backend."}, false);
                this.errorHandler.noTerminal();
            }
            this.emitProgress();
            return;
        }
    }
}

