/*
 * Decompiled with CFR 0.152.
 */
package ordermate.startup;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.guicore.task.AbstractTask;
import javax.swing.SwingUtilities;
import ordermate.OrderMate;
import ordermate.database.integration.LoyaltyIntegrationConfig;
import ordermate.database.misc.HOConfig;
import ordermate.database.misc.StoreGroup;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.loyalty.LoyaltyPointAdministrator;
import ordermate.hom.synchronisation.customer.CustomerLoyaltyPointAuthority;
import ordermate.integration.loyalty.igt.IGTLoyaltyPointAuthority;
import ordermate.integration.loyalty.trac.TracLoyaltyPointAuthority;

public class SetupLoyaltyTask
extends AbstractTask {
    private final GuiHandler guiHandler;

    public SetupLoyaltyTask(GuiHandler guiHandler) {
        this.guiHandler = guiHandler;
    }

    @Override
    public String getName() {
        return "Setup Loyalty Points";
    }

    @Override
    protected void performTask() throws Exception {
        if (SystemProperty.getInstance().isLoyaltyEnabled()) {
            if (LoyaltyIntegrationConfig.getInstance().getType().equals((Object)LoyaltyIntegrationConfig.LoyaltyIntegrationType.HO) && HOConfig.getInstance().isEnabled()) {
                if (HOConfig.getInstance().isMultisiteCustomers()) {
                    Long storeId = StoreGroup.getInstance().getStoreId();
                    if (storeId == null || storeId.equals(0L)) {
                        OrderMate.LOG.warn("Cannot use distributed loyalty, no store group Id has been set, or is zero.");
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SetupLoyaltyTask.this.guiHandler.displayOkDialog("No store group has been defined for Head Office loyalty integration.", "Loyalty Disabled");
                            }
                        });
                    } else {
                        LoyaltyPointAdministrator.getInstance().setAuthority(new CustomerLoyaltyPointAuthority(this.guiHandler));
                    }
                }
            } else if (LoyaltyIntegrationConfig.getInstance().getType().equals((Object)LoyaltyIntegrationConfig.LoyaltyIntegrationType.IGT)) {
                LoyaltyPointAdministrator.getInstance().setAuthority(new IGTLoyaltyPointAuthority(this.guiHandler));
            } else if (LoyaltyIntegrationConfig.getInstance().getType().equals((Object)LoyaltyIntegrationConfig.LoyaltyIntegrationType.TRAC)) {
                LoyaltyPointAdministrator.getInstance().setAuthority(new TracLoyaltyPointAuthority(this.guiHandler));
            }
        }
        this.emitProgress();
    }

    @Override
    protected int getTotalSubTasks() {
        return 1;
    }
}

