/*
 * Decompiled with CFR 0.152.
 */
package ordermate.startup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.OrderMate;
import ordermate.database.misc.SystemProperty;
import ordermate.signals.Signal;
import ordermate.startup.DeviceNotFoundException;
import ordermate.startup.OrderMateSetupException;

public class StartupErrorManager {
    private static StartupErrorManager instance = null;
    private Map<Integer, DeviceNotFoundException> deviceExceptionsList = new HashMap<Integer, DeviceNotFoundException>();
    private Signal<?, ?, ?, ?, ?> ringMeOnError = null;
    private static final int NEVER_STOP_ATTEMPTING_RESTART = -1;

    private StartupErrorManager() {
    }

    public static StartupErrorManager getInstance() {
        if (instance == null) {
            instance = new StartupErrorManager();
        }
        return instance;
    }

    public void setErrorSignal(Signal<?, ?, ?, ?, ?> newErrorSig) {
        this.ringMeOnError = newErrorSig;
    }

    public void ringErrorSignal() {
        if (this.ringMeOnError != null) {
            this.ringMeOnError.emit();
        }
    }

    private int getKeyForException(OrderMateSetupException exception) {
        return exception.hashCode();
    }

    public void addDeviceNotFoundException(DeviceNotFoundException exception) {
        int key = this.getKeyForException(exception);
        if (!this.deviceExceptionsList.containsKey(key)) {
            this.deviceExceptionsList.put(key, exception);
            this.ringErrorSignal();
        }
    }

    public void removeDeviceNotFoundException(DeviceNotFoundException exception) {
        if (this.deviceExceptionsList.containsKey(this.getKeyForException(exception))) {
            this.deviceExceptionsList.remove(this.getKeyForException(exception));
            this.ringErrorSignal();
        }
    }

    public boolean hadErrorsDuringStartup() {
        return !this.deviceExceptionsList.isEmpty();
    }

    public List<DeviceNotFoundException> getDeviceNotFoundErrors() {
        return new ArrayList<DeviceNotFoundException>(this.deviceExceptionsList.values());
    }

    public void clearErrorLists() {
        this.deviceExceptionsList.clear();
        this.ringErrorSignal();
    }

    public boolean hasStartupErrors() {
        return !this.deviceExceptionsList.isEmpty();
    }

    public boolean retryDeviceNotFoundExceptionTask(int key) {
        if (this.deviceExceptionsList.containsKey(key)) {
            return this.retryDeviceNotFoundExceptionTask(this.deviceExceptionsList.get(key));
        }
        return false;
    }

    public boolean retryDeviceNotFoundExceptionTask(DeviceNotFoundException exception) {
        boolean result = true;
        try {
            exception.incrementAttempts();
            exception.getRetryTask().run();
        }
        catch (DeviceNotFoundException ex1) {
            if (exception.getAttemptedRestarts() % 10 == 1) {
                OrderMate.LOG.error("RetryTask Failed: ", (Throwable)ex1);
            } else {
                OrderMate.LOG.error("RetryTask Failed: Still not connecting");
            }
            result = false;
        }
        catch (Exception ex2) {
            if (exception.getAttemptedRestarts() % 10 == 1) {
                OrderMate.LOG.error("RetryTask Failed UnexpectedException!: ", (Throwable)ex2);
            } else {
                OrderMate.LOG.error("RetryTask Failed Unexpectedly: Still not connecting");
            }
            result = false;
        }
        if (result) {
            this.removeDeviceNotFoundException(exception);
        } else if (SystemProperty.getInstance().getDeviceFailureNumRetryAttempts() != -1 && exception.getAttemptedRestarts() > SystemProperty.getInstance().getDeviceFailureNumRetryAttempts()) {
            OrderMate.LOG.warn("" + exception.getDevice().toString() + " failed " + exception.getAttemptedRestarts() + " times. Abandoning Task...");
            this.removeDeviceNotFoundException(exception);
            result = false;
        }
        return result;
    }
}

