/*
 * Decompiled with CFR 0.152.
 */
package ordermate.startup;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.DateTimeUtils;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Semaphore;
import ordermate.OrderMate;
import ordermate.database.departments.Department;
import ordermate.database.integration.labour.LabourIntegration;
import ordermate.database.integration.labour.LabourSummaryReport;
import ordermate.database.integration.webservice.WebserviceIntegrationConfig;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.general.DateReport;
import ordermate.integration.jaxb.webservice.labour.LabourDateReport;
import ordermate.integration.jaxb.webservice.labour.LabourDepartmentReport;
import ordermate.integration.jaxb.webservice.labour.LabourReport;
import ordermate.integration.jaxb.webservice.labour.LabourVerification;
import ordermate.integration.webservice.PassthroughX509TrustManager;
import ordermate.integration.webservice.RestHelper;
import ordermate.scheduler.Task;

public class SyncLabourTask
implements Task {
    public static final String NAME = "Sync Labour";
    private static Semaphore talkingStick = new Semaphore(1);
    private DateFormat dateFormat = new SimpleDateFormat("ddMMyyyy");
    private static final String ENDPOINT = "report/";
    private static final int TIMEOUT_MS = 60000;

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void run() {
        if (talkingStick.tryAcquire()) {
            try {
                this.performSync();
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot synchronize the labour figures with third party", (Throwable)ex);
            }
            talkingStick.release();
        } else {
            OrderMate.LOG.warn("Labour Integration already/still synchronizing, will not repeat.");
        }
    }

    @Override
    public void setData(Object data) {
    }

    private void performSync() {
        LabourIntegration integration = LabourIntegration.getInstance();
        if (integration.isActive()) {
            WebserviceIntegrationConfig config = integration.getWebserviceConfig();
            RestHelper helper = new RestHelper();
            StringBuilder SB = new StringBuilder(config.getUrl());
            if (!config.getUrl().endsWith("/")) {
                SB.append("/");
            }
            SB.append(ENDPOINT);
            Integer timeout = 60000;
            WebResource resource = config.getUrl().startsWith("https") ? helper.getSslResource(SB.toString(), new PassthroughX509TrustManager(), 5000, 5000) : helper.getResource(SB.toString(), timeout, timeout);
            resource = helper.addBasicAuth(resource, config.getUsername(), config.getPassword());
            String from = this.dateFormat.format(this.getFrom());
            String to = this.dateFormat.format(TradingDay.getCurrentTradingDay().getDate());
            resource = helper.addParameter(resource, "integrationid", integration.getExtId());
            resource = helper.addParameter(resource, "datefrom", from);
            resource = helper.addParameter(resource, "dateto", to);
            String outcome = null;
            try {
                ClientResponse response = (ClientResponse)resource.accept(new String[]{"application/xml"}).get(ClientResponse.class);
                OrderMate.LOG.info("Status:" + response.getStatus());
                outcome = response.getStatus() / 100 == 2 ? this.persistAndUpdateReports((LabourReport)response.getEntity(LabourReport.class)) : "Error - " + (String)response.getEntity(String.class);
            }
            catch (Exception ex) {
                OrderMate.LOG.warn("Cannot retrieve timesheet data from Third Party", (Throwable)ex);
                outcome = "Error in communication, see logs";
            }
            integration.setLastPull(new Date());
            integration.setLastResult(outcome);
            integration.save();
        } else {
            integration.setLastResult("Integration not active.");
        }
    }

    private Date applyHardLimitToFromDate(Date date) {
        Calendar cal = Calendar.getInstance();
        for (int i = 0; i < 30; ++i) {
            cal.add(6, -1);
        }
        DateTimeUtils.clearTimePart(cal);
        if (date.before(cal.getTime())) {
            return cal.getTime();
        }
        return date;
    }

    Date getFrom() {
        DateReport earliest = PersistenceManager.getObject(DateReport.class, Query.select(LabourSummaryReport.Properties.ID).select(LabourSummaryReport.Properties.REPORT_DATE, "value").equals(LabourSummaryReport.Properties.VERIFIED, (Object)LabourVerification.Not_Verified).orderBy(LabourSummaryReport.Properties.REPORT_DATE, false).limit(1).toString());
        if (earliest != null) {
            return this.applyHardLimitToFromDate(earliest.getValue());
        }
        DateReport latest = PersistenceManager.getObject(DateReport.class, Query.select(LabourSummaryReport.Properties.ID).select(LabourSummaryReport.Properties.REPORT_DATE, "value").orderBy(LabourSummaryReport.Properties.REPORT_DATE, true).limit(1).toString());
        if (latest != null) {
            return this.applyHardLimitToFromDate(latest.getValue());
        }
        TradingDay firstDay = PersistenceManager.getObject(TradingDay.class, Query.select(TradingDay.class).orderBy(TradingDay.Properties.DATE).limit(1).toString());
        return this.applyHardLimitToFromDate(firstDay.getDate());
    }

    String persistAndUpdateReports(LabourReport report) {
        Date from = report.getDateFrom().toGregorianCalendar().getTime();
        Date to = report.getDateTo().toGregorianCalendar().getTime();
        for (LabourDepartmentReport deptReport : report.getDepartments()) {
            Department dept = PersistenceManager.getObject(Department.class, Query.select(Department.class).equals((PropertiedObject.Property)Department.Properties.EXT_ID, deptReport.getId()).toString());
            if (dept != null) {
                HashMap<Date, LabourSummaryReport> reportMap = new HashMap<Date, LabourSummaryReport>();
                List<LabourSummaryReport> existingReports = PersistenceManager.getObjectList(LabourSummaryReport.class, Query.select(LabourSummaryReport.class).wherePropertyBetween(LabourSummaryReport.Properties.REPORT_DATE, from, to, SQLDateType.DATE).equals(LabourSummaryReport.Properties.DEPARTMENT, dept).toString());
                for (LabourSummaryReport existingReport : existingReports) {
                    reportMap.put(existingReport.getReportDate(), existingReport);
                }
                for (LabourDateReport tpReport : deptReport.getReports()) {
                    Date theDate = tpReport.getDate().toGregorianCalendar().getTime();
                    LabourSummaryReport dbReport = (LabourSummaryReport)reportMap.get(theDate);
                    if (dbReport == null) {
                        dbReport = new LabourSummaryReport(theDate, dept, tpReport.getTotalHours(), tpReport.getTotalCost(), tpReport.getVerified());
                        reportMap.put(theDate, dbReport);
                    } else {
                        dbReport.setVerified(tpReport.getVerified());
                        dbReport.setTotalCost(tpReport.getTotalCost());
                        dbReport.setTotalHours(tpReport.getTotalHours());
                    }
                    dbReport.save();
                }
                continue;
            }
            OrderMate.LOG.error("We received an incorrect department ext_id: " + deptReport.getId());
            return "Incorrect Department ID";
        }
        return "Success";
    }
}

