/*
 * Decompiled with CFR 0.152.
 */
package ordermate.startup;

import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.simplermi.SimpleRMI;
import au.com.ordermate.unique.Unique;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Set;
import ordermate.OrderMate;
import ordermate.security.UniqueServiceHelper;
import ordermate.security.UniqueServiceLocks;
import ordermate.security.UniqueTaskLockService;
import ordermate.startup.OrderMateSetupException;

public class UniqueTask
extends AbstractTask {
    private final String serviceName;
    private Set<Integer> ports;
    private final String user;

    public UniqueTask(String newServiceName, int newPort) {
        this(newServiceName, newPort, null);
    }

    public UniqueTask(String newServiceName, int newPort, String user) {
        this(newServiceName, user, Collections.singleton(newPort));
    }

    public UniqueTask(String newServiceName, String user, Set<Integer> possiblePorts) {
        this.serviceName = user != null ? newServiceName + " by user " + user : newServiceName;
        this.user = user;
        this.ports = possiblePorts;
    }

    @Override
    public int getTotalSubTasks() {
        return 1;
    }

    @Override
    public String getName() {
        return "Checking for " + this.serviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performTask() throws Exception {
        if (this.ports.isEmpty()) {
            this.ports = Collections.singleton(SimpleRMI.getSharePort());
        }
        if (this.ports.size() > 1 && PersistenceManager.getServerConnection() == null) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Long pid = UniqueServiceHelper.getProcessID();
        Long resultCode = null;
        if (PersistenceManager.getServerConnection() != null && pid != null && (resultCode = PersistenceManager.getServerConnection().runSync(new UniqueTaskLockService(UniqueTaskLockService.UniqueTaskLockCommand.LOCK, this.serviceName, InetAddress.getLocalHost().toString(), pid))) != null && resultCode.compareTo(UniqueServiceLocks.SUCCESS_RESULT_CODE) > 0 && !UniqueServiceHelper.isProcessRunning(resultCode, this.user)) {
            OrderMate.LOG.info("Attempting to reaquire the lock for serviceName: " + this.serviceName + ", ip: " + InetAddress.getLocalHost().toString() + ", pid: " + pid);
            resultCode = PersistenceManager.getServerConnection().runSync(new UniqueTaskLockService(UniqueTaskLockService.UniqueTaskLockCommand.REAQUIRE, this.serviceName, InetAddress.getLocalHost().toString(), pid));
        }
        if (!(PersistenceManager.getServerConnection() == null || resultCode != null && resultCode.equals(UniqueServiceLocks.SUCCESS_RESULT_CODE) && pid != null)) {
            SimpleRMI.shutdown();
            OrderMate.LOG.info("Throwing OrderMateSetupException within UniqueTask, connectionManager: " + (PersistenceManager.getServerConnection() != null) + ", resultCode: " + resultCode + ", pid: " + pid);
            this.throwException();
        }
        try {
            for (int nextPort : this.ports) {
                if (!Unique.isServiceRunning(InetAddress.getLocalHost(), this.serviceName, nextPort)) continue;
                SimpleRMI.shutdown();
                OrderMate.LOG.info("Service is already running on another port: " + nextPort);
                this.throwException();
            }
            OrderMate.LOG.info("Register unique service: " + this.serviceName);
            if (!Unique.registerService(this.serviceName)) {
                SimpleRMI.shutdown();
                OrderMate.LOG.error("Service was already registered: " + this.serviceName);
                this.throwException();
            }
        }
        finally {
            if (PersistenceManager.getServerConnection() != null && pid != null) {
                PersistenceManager.getServerConnection().runSync(new UniqueTaskLockService(UniqueTaskLockService.UniqueTaskLockCommand.UNLOCK, this.serviceName, InetAddress.getLocalHost().toString(), pid));
            }
        }
        this.emitProgress();
    }

    private void throwException() {
        throw new OrderMateSetupException((Task)this, "Another instance of " + this.serviceName + " is running! ", "Please close it before attempting to run another.", (Throwable)null, true);
    }
}

