/*
 * Decompiled with CFR 0.152.
 */
package ordermate.startup.laf;

import com.incors.plaf.kunststoff.KunststoffLookAndFeel;
import java.awt.Color;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalTheme;
import ordermate.OrderMate;
import ordermate.gui.themes.KunststoffOrderMateTheme;
import ordermate.startup.laf.AbstractLaFSetup;
import org.apache.commons.lang.ArrayUtils;

public class KunstoffSetup
extends AbstractLaFSetup {
    private final Color toggleColour;
    private final String bgColour;

    public KunstoffSetup(int theScale, String theFont, Color theToggleColour, String theBgColor) {
        super(theScale, theFont);
        this.toggleColour = theToggleColour;
        this.bgColour = theBgColor;
    }

    @Override
    public boolean setupLaF() throws Exception {
        Color bgColor = null;
        String colorSt = this.bgColour;
        String[] colors = colorSt.split(",");
        try {
            if (colors.length == 3) {
                bgColor = new Color(Integer.parseInt(colors[0]), Integer.parseInt(colors[1]), Integer.parseInt(colors[2]));
            } else {
                OrderMate.LOG.warn("Could not set background color");
            }
            OrderMate.LOG.info("Background color of kunststoff set : " + colorSt + " :" + ArrayUtils.toString((Object)colors));
        }
        catch (NumberFormatException ex) {
            OrderMate.LOG.warn("Could not parse background color.", (Throwable)ex);
        }
        KunststoffOrderMateTheme theme = KunststoffOrderMateTheme.setupTheme(this.getScale(), this.getFont(), this.toggleColour).setDefaultColor(bgColor);
        KunststoffLookAndFeel.setCurrentTheme((MetalTheme)((Object)theme));
        UIManager.setLookAndFeel((LookAndFeel)new KunststoffLookAndFeel());
        return true;
    }
}

