/*
 * Decompiled with CFR 0.152.
 */
package ordermate.startup.laf;

import java.awt.Color;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import ordermate.OrderMate;
import ordermate.startup.laf.AbstractLaFSetup;
import org.jvnet.lafwidget.utils.LafConstants;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.api.SubstanceConstants;
import org.jvnet.substance.api.SubstanceSkin;
import org.jvnet.substance.fonts.FontPolicy;
import org.jvnet.substance.fonts.SubstanceFontUtilities;

public class SubstanceSetup
extends AbstractLaFSetup {
    private final String laFName;
    private final boolean showWatermark;
    private final boolean paintGradient;
    private final Color toggleColour;

    public SubstanceSetup(int theScale, String theFont, Color toggle, String theLaFName, boolean isShowWatermark, boolean isShowGradient) {
        super(theScale, theFont);
        this.toggleColour = toggle == null ? Color.green : toggle;
        this.laFName = theLaFName;
        this.showWatermark = isShowWatermark;
        this.paintGradient = isShowGradient;
    }

    @Override
    public boolean setupLaF() throws Exception {
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                UIManager.put("substancelaf.focusKind", SubstanceConstants.FocusKind.NONE);
                UIManager.put("ToggleButton.select", SubstanceSetup.this.toggleColour);
                UIManager.put("lafwidgets.animationKind", LafConstants.AnimationKind.NONE);
                UIManager.put("substancelaf.colorizationFactor", new Double(0.98));
                try {
                    UIManager.setLookAndFeel(SubstanceSetup.this.laFName);
                    if (!SubstanceSetup.this.showWatermark) {
                        SubstanceLookAndFeel.setSkin((SubstanceSkin)SubstanceLookAndFeel.getCurrentSkin().withWatermark(null));
                    }
                    if (SubstanceSetup.this.getScale() != 0) {
                        SubstanceLookAndFeel.setFontPolicy((FontPolicy)SubstanceFontUtilities.getScaledFontPolicy((float)(1.0f + (float)SubstanceSetup.this.getScale() / 10.0f)));
                    }
                }
                catch (IllegalAccessException ila) {
                    OrderMate.LOG.error("IllegalAccess for " + SubstanceSetup.this.laFName, (Throwable)ila);
                }
                catch (UnsupportedLookAndFeelException ex2) {
                    OrderMate.LOG.error("Unsupported look and feel : " + SubstanceSetup.this.laFName, (Throwable)ex2);
                }
                catch (InstantiationException ex1) {
                    OrderMate.LOG.error("Could not instatiate look and feel " + SubstanceSetup.this.laFName, (Throwable)ex1);
                }
                catch (ClassNotFoundException ex) {
                    OrderMate.LOG.error("Look and feel class not found : " + SubstanceSetup.this.laFName, (Throwable)ex);
                }
            }
        });
        return SubstanceLookAndFeel.isCurrentLookAndFeel();
    }
}

