/*
 * Decompiled with CFR 0.152.
 */
package ordermate.startup.runtime;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.file.FileUtils;
import au.com.ordermate.util.file.FileZipper;
import java.io.File;
import java.io.IOException;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.misc.FTPHelper;

public class JavaRuntimeCheckTask
extends AbstractTask {
    private static final String ORDERMATE = "OrderMate";
    private static final String WAITERMATE = "WaiterMate";
    private static final String OFFICEMATE = "OfficeMate";
    private static final String KTSMATE = "KTSMate";
    private static final String TOUCHPREP_XPRESS = "TouchPrep XPress";
    private static final String FTP_ARCHER_DIRECTORY = "/Scripts/PrinterPatch/";
    private static final String FS = System.getProperty("file.separator");
    private static final String VERSION = "1.8.0_202";
    private final String JRE_PATH;
    private final String JRE_LIB_PATH;
    private final String JRE_BIN_PATH;
    private final String JRE_SECURITY_PATH;
    private final String[] TARGET_FILES;
    private String appName;
    private String smAddress;
    private boolean forceRun = false;

    public JavaRuntimeCheckTask(String appName) {
        this.appName = appName;
        this.JRE_PATH = System.getProperty("java.home");
        this.JRE_LIB_PATH = this.JRE_PATH + FS + "lib" + FS;
        this.JRE_BIN_PATH = this.JRE_PATH + FS + "bin" + FS;
        this.JRE_SECURITY_PATH = this.JRE_LIB_PATH + "security" + FS;
        this.TARGET_FILES = new String[]{this.JRE_LIB_PATH + "comm.jar", this.JRE_LIB_PATH + "javax.comm.properties", this.JRE_LIB_PATH + "native-dlls.jar", this.JRE_LIB_PATH + "rainbow.jar", this.JRE_LIB_PATH + "RXTXcomm.jar", this.JRE_SECURITY_PATH + "local_policy.jar", this.JRE_SECURITY_PATH + "README.txt", this.JRE_SECURITY_PATH + "US_export_policy.jar", this.JRE_BIN_PATH + "sxjdk.dll", this.JRE_BIN_PATH + "Win32com.dll"};
    }

    public void setServermateAddress(String address) {
        this.smAddress = address;
    }

    public void setForceRun(boolean value) {
        this.forceRun = value;
    }

    @Override
    public String getName() {
        return "JRE Version Check & Shortcut download";
    }

    @Override
    protected void performTask() throws Exception {
        if (FileUtils.isOSLinux() || this.isOSMac() || this.isDisabledByConfig()) {
            OrderMate.LOG.warn("Skipping Java Runtime Version check because of environment linux/mac/debug enabled");
            return;
        }
        if (!this.isJavaVersionMatches()) {
            OrderMate.LOG.info("Downloading JRE because of version mismatch");
            this.downloadAndExtractJRE();
            this.updateShortcuts();
        }
        if (this.appName.equalsIgnoreCase("Waitermate")) {
            this.updateShortcuts();
        }
        if (this.appName.equalsIgnoreCase("Waitermate")) {
            this.copyBinaries();
        }
        this.emitProgress();
    }

    public void copyBinaries() {
        OrderMate.LOG.info("Checking for files ");
        if (this.isFilesPresent()) {
            OrderMate.LOG.info("All required libraries and dlls are present");
            return;
        }
        if (!this.downloadAndExtractLibraries()) {
            OrderMate.LOG.error("Download And Extract Libraries have failed.");
            return;
        }
        this.copyFromTempToFolders();
    }

    private void copyFromTempToFolders() {
        String ZIP_PATH = "C:\\Temp\\PrinterPatch\\";
        for (String fileName : this.TARGET_FILES) {
            File f = new File(fileName);
            if (f.exists()) continue;
            String ZIP_PATH_FILENAME = "C:\\Temp\\PrinterPatch\\" + f.getName();
            try {
                FileUtils.copyFile(ZIP_PATH_FILENAME, f.toString());
            }
            catch (Exception ex) {
                OrderMate.LOG.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private boolean downloadAndExtractLibraries() {
        try {
            OrderMate.LOG.info("Downloading PrinterPatch from Updatemate");
            if (!FTPHelper.downloadFile("/Scripts/PrinterPatch/PrinterPatch.zip", "C:\\temp\\PrinterPatch.zip")) {
                OrderMate.LOG.error("Downloading file from Updatemate failed ");
            }
            if (!this.extractArchive()) {
                OrderMate.LOG.info("Extracting downloaded PrinterPatch.zip failed");
                return false;
            }
        }
        catch (Exception e) {
            OrderMate.LOG.error("Failed to deploy Printer Patch from FTP to local directory C:\\temp", (Throwable)e);
            return false;
        }
        return true;
    }

    private boolean extractArchive() {
        String zipFile = "C:\\temp\\PrinterPatch.zip";
        File targetFolder = new File("C:\\temp\\PrinterPatch\\");
        if (!targetFolder.exists()) {
            targetFolder.mkdir();
        }
        return new FileZipper().unzipIt(zipFile, targetFolder.getPath());
    }

    private boolean isFilesPresent() {
        boolean filePresent = true;
        for (String file : this.TARGET_FILES) {
            File f = new File(file);
            if (f.exists()) continue;
            OrderMate.LOG.error("File " + f.toString() + " is not present ");
            filePresent = false;
        }
        return filePresent;
    }

    private boolean isDisabledByConfig() {
        return this.forceRun || Config.isConfigSetup() && (Config.isDebuging() || Config.getBooleanValue("skip_version_check"));
    }

    private boolean isJavaVersionMatches() {
        String jreVersion = System.getProperty("java.version");
        boolean matches = VERSION.equals(jreVersion);
        OrderMate.LOG.info("For " + this.appName + " Expected JRE Version : " + VERSION + " Actual JRE Version of " + this.appName + " : " + jreVersion + " Matches : " + matches);
        if (matches) {
            File javaDir = new File(System.getProperty("java.home"));
            if (!javaDir.getAbsolutePath().endsWith("Java8")) {
                OrderMate.LOG.info("We're not on Java8 directory");
                return false;
            }
            javaDir = javaDir.getParentFile();
            File ordermateDir = new File(this.getInstallPath());
            while (javaDir.getParentFile() != null && !ordermateDir.equals(javaDir)) {
                javaDir = javaDir.getParentFile();
            }
            matches = javaDir.equals(ordermateDir);
            if (!matches) {
                OrderMate.LOG.info("However we are not running from the correct directory. Java home is:" + System.getProperty("java.home"));
            }
        }
        return matches;
    }

    @Override
    protected int getTotalSubTasks() {
        return 1;
    }

    private String getWebstartPath() {
        if (this.smAddress == null) {
            return "http://" + Terminal.getServerMateTerminal().getIPAddress() + "/Webstart/";
        }
        return "http://" + this.smAddress + "/Webstart/";
    }

    private boolean isOSMac() {
        return StringUtils.containsIgnoreCase(System.getProperty("os.name"), "mac");
    }

    private boolean downloadAndExtractJRE() {
        String productInstallPath = this.getInstallPath();
        String jrePath = productInstallPath + "\\Java8";
        String webStartPath = this.getWebstartPath() + "jre.zip";
        String localJREPath = jrePath + "\\jre.zip";
        try {
            boolean result;
            File jrePathFile = new File(jrePath);
            if (!jrePathFile.exists() && !(result = jrePathFile.mkdirs())) {
                OrderMate.LOG.warn("Could not create path for JRE");
            }
            OrderMate.LOG.info("Trying to download JRE from " + webStartPath + " to local path " + localJREPath);
            FileUtils.downloadFile(webStartPath, localJREPath);
            OrderMate.LOG.info("Trying to extract file : " + localJREPath + " to " + jrePath);
            boolean unzipped = new FileZipper().unzipIt(localJREPath, jrePath);
            if (!unzipped) {
                OrderMate.LOG.warn("Failed to unzip jre.zip to " + localJREPath + "! Could not install the JRE environment.");
                return false;
            }
            OrderMate.LOG.info("JavaRuntimeCheckTask: Successfully unpacked JRE to POS JRE directory.");
            return true;
        }
        catch (IOException e) {
            OrderMate.LOG.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private String getInstallPath() {
        String installPath = this.getOrdermateInstallPath();
        if (OFFICEMATE.equalsIgnoreCase(this.appName)) {
            installPath = this.getOrdermateInstallPath();
        } else if (WAITERMATE.equalsIgnoreCase(this.appName)) {
            installPath = this.getWaitermateInstallPath();
        } else if (TOUCHPREP_XPRESS.equalsIgnoreCase(this.appName)) {
            installPath = this.getKTSMateInstallPath();
        }
        return installPath;
    }

    private String getParentPath() {
        return FileUtils.is64BitOperatingSystem() ? "C:\\Program Files (x86)\\" : "C:\\Program Files\\";
    }

    private String getWaitermateInstallPath() {
        File f = new File(this.getOrdermateInstallPath());
        String waitermateFile = this.getParentPath() + WAITERMATE;
        if (f.exists()) {
            return f.toString();
        }
        return waitermateFile;
    }

    private String getKTSMateInstallPath() {
        File f = new File(this.getOrdermateInstallPath());
        String ktsMateFile = this.getParentPath() + KTSMATE;
        if (f.exists()) {
            return f.toString();
        }
        return ktsMateFile;
    }

    private String getOrdermateInstallPath() {
        return this.getParentPath() + ORDERMATE;
    }

    private void updateShortcuts() {
        if (Config.isConfigSetup() && Config.getBooleanValue("skip_shortcut_update")) {
            OrderMate.LOG.info("Skipping shortcut update because skip_shortcut_update is true in config");
            return;
        }
        String userHome = System.getProperty("user.home");
        if (this.downloadIcon()) {
            File shortcutFile = this.makeShortcut();
            if (shortcutFile != null && shortcutFile.exists()) {
                this.updateShortcut(shortcutFile, userHome + "/Desktop/" + this.appName + ".lnk", "Failed to update desktop shortcuts!");
                this.copyShortCutsToStartupFolder(shortcutFile, userHome);
            } else {
                OrderMate.LOG.warn("Cannot update shortcuts, created file is not there.");
            }
        }
    }

    private File makeShortcut() {
        String sep = File.separator;
        File shortcutFile = null;
        try {
            String path = this.getInstallPath() + sep + this.appName + ".lnk";
            String server = "ORDERMATE";
            OrderMate.LOG.info("Making shortcut at:" + path);
            shortcutFile = FileUtils.createShortcut(path, this.getInstallPath() + sep + "Java8" + sep + "bin" + sep + "javaws.exe", "-shortcut http://" + server + "/webstart/" + this.appName.toLowerCase() + ".jnlp", this.getIconFile(this.appName).getAbsolutePath(), this.getInstallPath() + sep + "Temp");
        }
        catch (IOException ex) {
            OrderMate.LOG.error("Cannot create shortcut for " + this.appName, (Throwable)ex);
        }
        return shortcutFile;
    }

    private boolean downloadIcon() {
        File expectedIconLocation = this.getIconFile(this.appName);
        OrderMate.LOG.info("Looking for icon in:" + expectedIconLocation + " " + expectedIconLocation.exists());
        if (!expectedIconLocation.exists()) {
            String serverIconLocation = this.getWebstartPath() + "images/" + expectedIconLocation.getName();
            OrderMate.LOG.info("Downloading icon from " + serverIconLocation);
            try {
                File dir = expectedIconLocation.getParentFile();
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                FileUtils.downloadFile(serverIconLocation, expectedIconLocation.getAbsolutePath());
            }
            catch (IOException ex) {
                OrderMate.LOG.error("Cannot download the icon from " + serverIconLocation, (Throwable)ex);
            }
        }
        return expectedIconLocation.exists();
    }

    private File getIconFile(String name) {
        return new File(this.getInstallPath() + File.separator + name.toLowerCase() + ".ico");
    }

    protected void copyShortCutsToStartupFolder(File shortcut, String userHome) {
        this.updateShortcut(shortcut, userHome + "/Start Menu/Startup/" + this.appName + ".lnk", "Failed to update XP startup shortcuts! (This is safe to ignore if system is Win7-10 based)");
        this.updateShortcut(shortcut, userHome + "/AppData/Roaming/Microsoft/Windows/Start Menu/Programs/Startup/" + this.appName + ".lnk", "Failed to update Win7/10 startup shortcuts! (This is safe to ignore if system is XP-based)");
    }

    private void updateShortcut(File shortcutFile, String targetFile, String errorMessage) {
        try {
            File targetLocation = new File(targetFile).getParentFile();
            if (!targetLocation.exists()) {
                boolean result = targetLocation.mkdirs();
                if (result) {
                    OrderMate.LOG.info("JavaRuntimeCheckTask.updateShortcut :: The parent location was created successfully " + targetLocation);
                } else {
                    OrderMate.LOG.info("JavaRuntimeCheckTask.updateShortcut :: The parent location creation failed " + targetLocation);
                    return;
                }
            }
            FileUtils.copyFile(shortcutFile.toString(), targetFile);
            OrderMate.LOG.info(this.appName + " startup shortcut updated!");
        }
        catch (IOException e) {
            OrderMate.LOG.error(errorMessage, (Throwable)e);
        }
    }
}

