/*
 * Decompiled with CFR 0.152.
 */
package ordermate.startup.runtime;

import java.util.Arrays;
import java.util.List;
import ordermate.OrderMate;

public class WindowsRegistryHelper {
    private static final String REG_KEY_JAVA_HOME = "JavaHome";
    private static final String REG_KEY_INSTALLDIR = "INSTALLDIR";
    private static final String REG_ENTRY_BASE_PATH = "HKLM\\Software\\JavaSoft\\Java Runtime Environment\\";
    private static final String REG_ENTRY_JRE = "1.7";
    private static final String REG_ENTRY_JRE_FINE = "1.7.0_17";
    private static final String REG_ENTRY_JRE_MSI = "1.7.0_17\\MSI";
    public static final String REG_PARAM_X86_VIEW = "/reg:32";
    public static final String REG_PARAM_X64_VIEW = "/reg:64";

    public static boolean setJavaHomeInRegistry(String targetJavaDirectory) {
        List<String> CMD_JRE_1 = WindowsRegistryHelper.buildCommandToSetValueInRegistry(WindowsRegistryHelper.buildRegistryPathToJava(REG_ENTRY_JRE), REG_KEY_JAVA_HOME, targetJavaDirectory, REG_PARAM_X86_VIEW);
        List<String> CMD_JRE_2 = WindowsRegistryHelper.buildCommandToSetValueInRegistry(WindowsRegistryHelper.buildRegistryPathToJava(REG_ENTRY_JRE_FINE), REG_KEY_JAVA_HOME, targetJavaDirectory, REG_PARAM_X86_VIEW);
        List<String> CMD_JRE_3 = WindowsRegistryHelper.buildCommandToSetValueInRegistry(WindowsRegistryHelper.buildRegistryPathToJava(REG_ENTRY_JRE_MSI), REG_KEY_INSTALLDIR, targetJavaDirectory, REG_PARAM_X86_VIEW);
        List<String> CMD_JRE_4 = WindowsRegistryHelper.buildCommandToSetValueInRegistry(WindowsRegistryHelper.buildRegistryPathToJava(REG_ENTRY_JRE), REG_KEY_JAVA_HOME, targetJavaDirectory, REG_PARAM_X64_VIEW);
        List<String> CMD_JRE_5 = WindowsRegistryHelper.buildCommandToSetValueInRegistry(WindowsRegistryHelper.buildRegistryPathToJava(REG_ENTRY_JRE_FINE), REG_KEY_JAVA_HOME, targetJavaDirectory, REG_PARAM_X64_VIEW);
        List<String> CMD_JRE_6 = WindowsRegistryHelper.buildCommandToSetValueInRegistry(WindowsRegistryHelper.buildRegistryPathToJava(REG_ENTRY_JRE_MSI), REG_KEY_INSTALLDIR, targetJavaDirectory, REG_PARAM_X64_VIEW);
        try {
            int result = new ProcessBuilder(CMD_JRE_1).redirectErrorStream(true).start().waitFor();
            result += new ProcessBuilder(CMD_JRE_2).redirectErrorStream(true).start().waitFor();
            result += new ProcessBuilder(CMD_JRE_3).redirectErrorStream(true).start().waitFor();
            result += new ProcessBuilder(CMD_JRE_4).redirectErrorStream(true).start().waitFor();
            result += new ProcessBuilder(CMD_JRE_5).redirectErrorStream(true).start().waitFor();
            if ((result += new ProcessBuilder(CMD_JRE_6).redirectErrorStream(true).start().waitFor()) > 0) {
                OrderMate.LOG.warn(result + " registry entries were not updated correctly!");
                return false;
            }
        }
        catch (Exception e) {
            OrderMate.LOG.error("Failed to update the registry!", (Throwable)e);
            return false;
        }
        return true;
    }

    private static String buildRegistryPathToJava(String path) {
        return "\"HKLM\\Software\\JavaSoft\\Java Runtime Environment\\" + path + "\"";
    }

    private static List<String> buildCommandToSetValueInRegistry(String path, String key, String value, String regView) {
        return Arrays.asList("C:\\Windows\\System32\\reg.exe", "ADD", path, "/v", key, "/t", "REG_SZ", "/d", value, "/f", regView);
    }
}

