/*
 * Decompiled with CFR 0.152.
 */
package ordermate.timesync;

import au.com.ordermate.simplermi.SimpleRMI;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.timesync.TimeServer;

public abstract class TimeClient {
    private static final long NOW = 0L;
    protected static final int MILLIS_IN_A_DAY = 86400000;
    private static final long STANDARD_INTERVAL = 43200000L;
    private static final long ERROR_INTERVAL = 60000L;
    private static final long ACCEPTABLE_ERROR = 500L;
    private static final int SAMPLE_NUMBER = 8;
    private int failCount = 0;
    private static TimeServer timeServer;
    private static TimeClient instance;

    public TimeClient() {
        instance = this;
    }

    public static TimeClient getInstance() {
        return instance;
    }

    public void start() throws Exception {
        this.connect();
        this.schedule(0L);
    }

    public void connect() throws Exception {
        timeServer = (TimeServer)SimpleRMI.getObject(Terminal.getServerMateTerminal().getAddress(), "OrderMate Time Server", 11100);
    }

    private void schedule(long nextRunDelay) {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Timer threadTimer = new Timer();
        threadTimer.schedule((TimerTask)new TimeClientRunner(), nextRunDelay);
    }

    protected abstract boolean changeTime(long var1);

    private class TimeClientRunner
    extends TimerTask {
        private TimeClientRunner() {
        }

        @Override
        public void run() {
            OrderMate.LOG.info("Synchronizing with Server clock...");
            ArrayList<long[]> timeSamples = new ArrayList<long[]>();
            boolean success = false;
            String message = "";
            long nextRun = 43200000L;
            try {
                for (int i = 0; i < 8; ++i) {
                    long[] timestamps = new long[]{System.currentTimeMillis(), timeServer.requestTime(), System.currentTimeMillis()};
                    timeSamples.add(timestamps);
                    Thread.sleep(1000L);
                }
                success = true;
            }
            catch (Exception e) {
                message = "Time Sync failed, could not connect to server.";
            }
            if (success) {
                long[] mostAccurate = new long[3];
                Long bestDelay = null;
                for (long[] timestamps : timeSamples) {
                    long delay = timestamps[2] - timestamps[0];
                    if (bestDelay != null && delay >= bestDelay) continue;
                    mostAccurate = timestamps;
                    bestDelay = new Long(delay);
                }
                long offset = (2L * mostAccurate[1] - mostAccurate[0] - mostAccurate[2]) / 2L;
                if (Math.abs(offset) > 500L) {
                    nextRun = 60000L;
                    TimeClient.this.failCount++;
                    message = TimeClient.this.changeTime(offset) ? "Terminal clock was out by " + offset + " milliseconds. Time adjusted." : "Time Sync failed, could not change system clock.";
                    if (TimeClient.this.failCount >= 10) {
                        message = "After 10 attempts this terminal is not time synchronized.\nThe clock is " + offset + "milliseconds different from the server.\n";
                        TimeClient.this.failCount = 0;
                        nextRun = 43200000L;
                    }
                } else {
                    message = "Terminal clock was in sync, no adjustment required.";
                    TimeClient.this.failCount = 0;
                }
            }
            OrderMate.LOG.info(message);
            TimeClient.this.schedule(nextRun);
        }
    }
}

