/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource;

import au.com.ordermate.util.DateTimeUtils;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import ordermate.OrderMate;

public abstract class AbstractResource {
    private static final String UNKNOWN_SERVER_ERROR_MSG = "Unknown Internal Server Error";
    private static final String UNKNOWN_BAD_REQUEST_MSG = "Unknown Bad Request";
    private static final String DEFAULT_NOT_FOUND_MSG = "Not Found";
    @Context
    HttpHeaders headers;

    protected HttpHeaders getHeaders() {
        return this.headers;
    }

    protected MediaType getMediaType() {
        MediaType mt;
        String qValue;
        if (this.headers == null) {
            return MediaType.APPLICATION_XML_TYPE;
        }
        List acceptHeaders = this.headers.getAcceptableMediaTypes();
        if (acceptHeaders == null || acceptHeaders.size() == 0) {
            return MediaType.APPLICATION_XML_TYPE;
        }
        Iterator iterator = acceptHeaders.iterator();
        while (iterator.hasNext() && ((qValue = (String)(mt = (MediaType)iterator.next()).getParameters().get("q")) == null || Double.valueOf(qValue) != 0.0)) {
            if (MediaType.APPLICATION_XML_TYPE.isCompatible(mt)) {
                return MediaType.APPLICATION_XML_TYPE;
            }
            if (!MediaType.APPLICATION_JSON_TYPE.isCompatible(mt)) continue;
            return MediaType.APPLICATION_JSON_TYPE;
        }
        return null;
    }

    protected Response getOKResponse(Object entity) {
        return Response.status((Response.Status)Response.Status.OK).type(this.getMediaType()).entity(entity).build();
    }

    protected Response getCreatedResponse(Object entity) {
        return Response.status((Response.Status)Response.Status.CREATED).type(this.getMediaType()).entity(entity).build();
    }

    protected Response getNotAcceptableResponse(List<Variant> acceptableTypes) {
        return Response.notAcceptable(acceptableTypes).build();
    }

    protected Response getBadRequestResponse(String msg) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)(msg != null ? msg : UNKNOWN_BAD_REQUEST_MSG)).build();
    }

    protected Response getInternalServerErrorResponse(String msg) {
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)(msg != null ? msg : UNKNOWN_SERVER_ERROR_MSG)).build();
    }

    protected Response getResponse(Object responseObj, Response.Status responseStatus, MediaType mediaType) {
        if (Response.Status.INTERNAL_SERVER_ERROR.equals((Object)responseStatus)) {
            return Response.status((Response.Status)responseStatus).type(mediaType).entity(responseObj != null ? responseObj : UNKNOWN_SERVER_ERROR_MSG).build();
        }
        return Response.status((Response.Status)responseStatus).type(mediaType).entity(responseObj).build();
    }

    protected void throwBadRequestException(String msg) {
        throw new WebApplicationException(this.getBadRequestResponse(msg));
    }

    protected Response getNoContentResponse(Object responseObj) {
        return Response.noContent().type(MediaType.APPLICATION_XML_TYPE).entity(responseObj).build();
    }

    protected Response getNotFoundResponse(String msg) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).type(MediaType.TEXT_PLAIN_TYPE).entity((Object)(msg != null ? msg : DEFAULT_NOT_FOUND_MSG)).build();
    }

    protected Response getNotFoundResponse() {
        return this.getNotFoundResponse(null);
    }

    protected Date parseBasicDate(String text) {
        try {
            return DateTimeUtils.getBasicDateFormat().parse(text);
        }
        catch (ParseException e) {
            OrderMate.LOG.warn("AbstractResource - Invalid date parameter: " + text);
            return null;
        }
    }

    protected Date getBasicDate(String dateStr) {
        if (dateStr != null && !dateStr.isEmpty()) {
            return this.parseBasicDate(dateStr);
        }
        return null;
    }

    protected Response getResponse(Object entity) {
        MediaType mediaType = this.getMediaType();
        if (mediaType == null) {
            return this.getNotAcceptableResponse(Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.APPLICATION_XML_TYPE, MediaType.APPLICATION_JSON_TYPE}).build());
        }
        return Response.ok((Object)entity).type(mediaType).build();
    }
}

