/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import ordermate.OrderMate;

@Provider
@Produces(value={"application/octet-stream"})
public class SerializableMessageBodyWriter
implements MessageBodyWriter<Serializable> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Serializable.class.isAssignableFrom(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize(Serializable t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (t == null) {
            return 0L;
        }
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(byteOut);
            out.writeObject(t);
        }
        catch (IOException ex) {
            OrderMate.LOG.warn("Cannot serialize object" + t, (Throwable)ex);
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException ex) {
                    OrderMate.LOG.warn("Cannot close off object stream", (Throwable)ex);
                }
            }
        }
        return byteOut.size();
    }

    public void writeTo(Serializable t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        try {
            ObjectOutputStream out = new ObjectOutputStream(entityStream);
            out.writeObject(t);
            out.flush();
        }
        catch (IOException ex) {
            OrderMate.LOG.warn("Trouble serializing object to output stream:", (Throwable)ex);
        }
    }
}

