/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource;

import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.datatype.DatatypeConfigurationException;
import ordermate.OrderMate;
import ordermate.webresource.WebResourceHelper;

public abstract class WebResourceExporter<T> {
    protected final WebResourceHelper helper;

    public WebResourceExporter() {
        WebResourceHelper theHelper = null;
        try {
            theHelper = new WebResourceHelper();
        }
        catch (DatatypeConfigurationException ex) {
            OrderMate.LOG.warn("WebResourceHelper could not be created for " + this.getName(), (Throwable)ex);
        }
        this.helper = theHelper;
    }

    public void exportRoot(T root, OutputStream output) throws JAXBException {
        if (output == null) {
            throw new IllegalArgumentException("The outputStream cannot be null.");
        }
        Class[] boundClasses = this.getBoundClasses();
        Marshaller marshaller = JAXBContext.newInstance((Class[])boundClasses).createMarshaller();
        marshaller.marshal(root, output);
    }

    protected abstract Class[] getBoundClasses();

    public abstract String getName();
}

