/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import ordermate.OrderMate;
import org.apache.commons.codec.binary.Hex;

public class WebResourceHelper {
    private DatatypeFactory datatypeFactory = DatatypeFactory.newInstance();

    public Date convertLongStringToDate(String value) {
        if (value != null) {
            return new Date(Long.valueOf(value));
        }
        return null;
    }

    public XMLGregorianCalendar makeDate(Date date) {
        if (date == null || this.datatypeFactory == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return this.makeDate(cal);
    }

    public XMLGregorianCalendar makeDate(Calendar cal) {
        return this.datatypeFactory.newXMLGregorianCalendarDate(cal.get(1), cal.get(2) + 1, cal.get(5), Integer.MIN_VALUE);
    }

    public XMLGregorianCalendar makeTime(Calendar time) {
        return this.datatypeFactory.newXMLGregorianCalendarTime(time.get(11), time.get(12), time.get(13), Integer.MIN_VALUE);
    }

    public XMLGregorianCalendar makeDateTime(Date datetime) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(datetime);
        return this.makeDateTime(cal);
    }

    public XMLGregorianCalendar makeDateTime(Calendar datetime) {
        return this.datatypeFactory.newXMLGregorianCalendar(BigInteger.valueOf(datetime.get(1)), datetime.get(2) + 1, datetime.get(5), datetime.get(11), datetime.get(12), datetime.get(13), BigDecimal.valueOf(datetime.get(14) / 1000), Integer.MIN_VALUE);
    }

    public void validateDates(Calendar from, Calendar to) {
        if (from.getTime().after(to.getTime())) {
            Date temp = from.getTime();
            from.setTime(to.getTime());
            to.setTime(temp);
        }
        long now = System.currentTimeMillis();
        if (from.getTimeInMillis() > now) {
            from.setTimeInMillis(now);
        }
        if (to.getTimeInMillis() > now) {
            to.setTimeInMillis(now);
        }
    }

    public static String generateHMAC(String message, String secretKey) {
        String HMAC_STR = "HmacSHA1";
        String ISO_CHAR_SET_STR = "ISO-8859-1";
        try {
            Mac hmac = Mac.getInstance("HmacSHA1");
            SecretKeySpec secret = new SecretKeySpec(secretKey.getBytes("ISO-8859-1"), "HmacSHA1");
            hmac.init(secret);
            byte[] hash = hmac.doFinal(message.getBytes("ISO-8859-1"));
            byte[] hexBytes = new Hex().encode(hash);
            return new String(hexBytes, "ISO-8859-1").toUpperCase();
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error generating HMAC key.", (Throwable)ex);
            return null;
        }
    }
}

