/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.accounting;

import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import ordermate.OrderMate;
import ordermate.integration.finance.common.AccountExportInput;
import ordermate.integration.finance.common.AccountingWebExport;
import ordermate.integration.jaxb.webservice.accounting.AccountExportList;
import ordermate.integration.jaxb.webservice.accounting.StockOrderType;
import ordermate.webresource.AbstractResource;

@Path(value="")
public class AccountingResource
extends AbstractResource {
    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/sales_finance")
    public Response getSalesAndFinance(@QueryParam(value="fromDate") String from, @QueryParam(value="toDate") String to) {
        List<Date> dateInterval = this.getDateInterval(from, to);
        Date fromDate = dateInterval.get(0);
        Date toDate = dateInterval.get(1);
        toDate = DateTimeUtils.addTime(toDate, 5, 1);
        try {
            AccountExportList accountExportList = AccountingWebExport.SHIFT_LINE_ITEM.getAccountExportList(new AccountExportInput.AccountExportInputBuilder(fromDate, toDate).build());
            if (accountExportList.getShiftLineItems().isEmpty()) {
                return this.getNoContentResponse(accountExportList);
            }
            return this.getResponse(accountExportList);
        }
        catch (Exception e) {
            OrderMate.LOG.error("General exception is occurred attempting to call sales_finance webservice!", (Throwable)e);
            return this.getResponse(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, MediaType.TEXT_PLAIN_TYPE);
        }
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/stock_movement")
    public Response getStockMovements(@QueryParam(value="fromDate") String from, @QueryParam(value="toDate") String to) {
        List<Date> dateInterval = this.getDateInterval(from, to);
        Date fromDate = dateInterval.get(0);
        Date toDate = dateInterval.get(1);
        toDate = DateTimeUtils.getEndOfDay(toDate);
        try {
            AccountExportList accountExportList = AccountingWebExport.STOCK_MOVEMENT.getAccountExportList(new AccountExportInput.AccountExportInputBuilder(fromDate, toDate).build());
            if (accountExportList.getStockMovements().isEmpty()) {
                return this.getNoContentResponse(accountExportList);
            }
            return this.getResponse(accountExportList);
        }
        catch (IllegalStateException e) {
            return this.getResponse(e.getMessage(), Response.Status.NOT_FOUND, MediaType.TEXT_PLAIN_TYPE);
        }
        catch (Exception e) {
            OrderMate.LOG.error("General exception is occurred attempting to call stock_movement webservice!", (Throwable)e);
            return this.getResponse(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, MediaType.TEXT_PLAIN_TYPE);
        }
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/stock_order")
    public Response getStockOrders(@QueryParam(value="fromDate") String from, @QueryParam(value="toDate") String to, @QueryParam(value="orderType") String orderType) {
        List<Date> dateInterval = this.getDateInterval(from, to);
        Date fromDate = dateInterval.get(0);
        Date toDate = dateInterval.get(1);
        fromDate = DateTimeUtils.addTime(fromDate, 5, -1);
        toDate = DateTimeUtils.addTime(toDate, 5, 1);
        try {
            AccountExportList accountExportList = AccountingWebExport.ORDER.getAccountExportList(new AccountExportInput.AccountExportInputBuilder(fromDate, toDate).types(this.parseOrderTypes(orderType)).build());
            if (accountExportList.getStockOrders().isEmpty()) {
                return this.getNoContentResponse(accountExportList);
            }
            return this.getResponse(accountExportList);
        }
        catch (WebApplicationException e) {
            return e.getResponse();
        }
        catch (Exception e) {
            OrderMate.LOG.error("General exception is occurred attempting to call stock_orders webservice!", (Throwable)e);
            return this.getResponse(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, MediaType.TEXT_PLAIN_TYPE);
        }
    }

    private List<String> parseOrderTypes(String typesText) {
        ArrayList<String> invoiceTypes = new ArrayList<String>();
        for (String type : StringUtils.splitToList(typesText, ",")) {
            if (StockOrderType.PURCHASE.value().equalsIgnoreCase(type.trim())) {
                invoiceTypes.add("Purchase Order");
                continue;
            }
            if (StockOrderType.CREDIT.value().equalsIgnoreCase(type.trim())) {
                invoiceTypes.add("Credit Note");
                continue;
            }
            if (StockOrderType.INVOICE.value().equalsIgnoreCase(type.trim())) {
                invoiceTypes.add("Invoice");
                continue;
            }
            if (StockOrderType.DELIVERY.value().equalsIgnoreCase(type.trim())) {
                invoiceTypes.add("Delivery Note");
                continue;
            }
            this.throwBadRequestException("Invalid stock order type: " + type);
        }
        return invoiceTypes;
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/stock_supplier")
    public Response getStockSuppliers(@QueryParam(value="changedSince") String changedSince) {
        Date date = DateTimeUtils.MINIMUM_DATE;
        if (changedSince != null && !changedSince.isEmpty()) {
            date = this.getBasicDate(changedSince);
        }
        if (date == null) {
            this.throwBadRequestException("Invalid date parameter: " + changedSince);
        }
        try {
            AccountExportList accountExportList = AccountingWebExport.SUPPLIER.getAccountExportList(new AccountExportInput.AccountExportInputBuilder(date, new Date()).build());
            if (accountExportList.getStockSuppliers() == null || accountExportList.getStockSuppliers().isEmpty()) {
                return this.getNoContentResponse(accountExportList);
            }
            return this.getResponse(accountExportList);
        }
        catch (Exception e) {
            OrderMate.LOG.error("General exception is occurred attempting to call stock_suppliers webservice!", (Throwable)e);
            return this.getResponse(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, MediaType.TEXT_PLAIN_TYPE);
        }
    }

    private List<Date> getDateInterval(String from, String to) {
        Date toDate;
        Date fromDate = this.getBasicDate(from);
        if (fromDate == null) {
            this.throwBadRequestException("Invalid date parameter, fromDate: " + from);
        }
        if ((toDate = this.getBasicDate(to)) == null) {
            this.throwBadRequestException("Invalid date parameter, toDate: " + to);
        }
        if (toDate != null && toDate.compareTo(fromDate) < 0) {
            this.throwBadRequestException(" toDate cannot be smaller than fromDate parameter! fromDate:" + fromDate + " / toDate:" + toDate);
        }
        ArrayList<Date> dateInterval = new ArrayList<Date>();
        dateInterval.add(fromDate);
        dateInterval.add(toDate);
        return dateInterval;
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="/stock_report")
    public Response getStockReport(@QueryParam(value="fromDate") String from, @QueryParam(value="toDate") String to) {
        List<Date> dateInterval = this.getDateInterval(from, to);
        Date fromDate = dateInterval.get(0);
        Date toDate = dateInterval.get(1);
        toDate = DateTimeUtils.getEndOfDay(toDate);
        try {
            AccountExportList accountExportList = AccountingWebExport.STOCK_REPORT.getAccountExportList(new AccountExportInput.AccountExportInputBuilder(fromDate, toDate).build());
            if (accountExportList.getStockReports().isEmpty()) {
                return this.getNoContentResponse(accountExportList);
            }
            return this.getResponse(accountExportList);
        }
        catch (Exception e) {
            OrderMate.LOG.error("General exception is occurred attempting to call stock_report webservice!", (Throwable)e);
            return this.getResponse(e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, MediaType.TEXT_PLAIN_TYPE);
        }
    }
}

