/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.adyen;

import au.com.ordermate.util.Pair;
import au.com.ordermate.xmlintegration.adyen.AdyenAmountReq;
import au.com.ordermate.xmlintegration.adyen.AdyenMessageHeader;
import au.com.ordermate.xmlintegration.adyen.AdyenPOITxnID;
import au.com.ordermate.xmlintegration.adyen.AdyenPaymentData;
import au.com.ordermate.xmlintegration.adyen.AdyenPaymentRequest;
import au.com.ordermate.xmlintegration.adyen.AdyenPaymentResponse;
import au.com.ordermate.xmlintegration.adyen.AdyenPaymentTransaction;
import au.com.ordermate.xmlintegration.adyen.AdyenSaleData;
import au.com.ordermate.xmlintegration.adyen.AdyenSaleToPOIRequest;
import au.com.ordermate.xmlintegration.adyen.AdyenSaleToPOIResponse;
import au.com.ordermate.xmlintegration.adyen.AdyenSaleTransactionID;
import au.com.payback.xmlintegration.payattable.PaTPaymentResult;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.finance.transactions.FinanceUnit;

public class AdyenOPayUtils {
    private static final List<Pair<String, FinanceUnit>> uuidTypes = new ArrayList<Pair<String, FinanceUnit>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTypeToUUID(String uuid, FinanceUnit unit) {
        List<Pair<String, FinanceUnit>> list = uuidTypes;
        synchronized (list) {
            uuidTypes.add(new Pair<String, FinanceUnit>(uuid, unit));
        }
    }

    private static String createSaleToAcquirerData(String businessName, String businessInfo, String Version2) {
        return "applicationInfo.externalPlatform.name=" + businessName + " - " + businessInfo + "&applicationInfo.externalPlatform.version=" + Version2 + "&applicationInfo.externalPlatform.integrator=OrderMate&applicationInfo.merchantApplication.name=OrderMate POS&applicationInfo.merchantApplication.version=" + Version2;
    }

    public static String cleanHTMLCharacters(String s) {
        String toReturn = s.replaceAll("%20", " ");
        toReturn = toReturn.replaceAll("%24", "\\$");
        toReturn = toReturn.replaceAll("%3a", ":");
        toReturn = toReturn.replaceAll("%2a", "*");
        toReturn = toReturn.replaceAll("%2f", "/");
        return toReturn;
    }

    public static AdyenSaleToPOIRequest createPaymentPOIRequest(AdyenMessageHeader header, String txnID, BigDecimal amount, BigDecimal tipAmt, BigDecimal cashAmt, String cardAcqTimeStamp, String cardAcqID, String businessName, String businessInfo, String Version2) {
        AdyenPaymentRequest req = new AdyenPaymentRequest();
        AdyenSaleData salesData = new AdyenSaleData();
        salesData.setSaleToAcquirerData(AdyenOPayUtils.createSaleToAcquirerData(businessName, businessInfo, Version2));
        AdyenSaleTransactionID transID = new AdyenSaleTransactionID();
        transID.setTransactionID(txnID);
        transID.setTimeStamp(new SimpleDateFormat("yyy-MM-dd'T'HH:mm:ss'+11:00'").format(new Date()));
        salesData.setSaleTransactionID(transID);
        AdyenPaymentTransaction pTxn = new AdyenPaymentTransaction();
        AdyenAmountReq aReq = new AdyenAmountReq();
        aReq.setCurrency("AUD");
        aReq.setRequestedAmount(amount);
        if (cardAcqTimeStamp != null && cardAcqID != null) {
            AdyenPaymentData data = new AdyenPaymentData();
            data.setCardAcquisitionReference(AdyenOPayUtils.createPOITxnID(cardAcqTimeStamp, cardAcqID));
            data.setSplitPaymentFlag(false);
            req.setPaymentData(data);
        }
        if (tipAmt != null && tipAmt.compareTo(BigDecimal.ZERO) > 0) {
            aReq.setTipAmount(tipAmt);
        }
        if (cashAmt != null && cashAmt.compareTo(BigDecimal.ZERO) > 0) {
            aReq.setCashBackAmount(cashAmt);
        }
        pTxn.setAmountsReq(aReq);
        req.setSaleData(salesData);
        req.setPaymentTransaction(pTxn);
        return AdyenOPayUtils.createRequest(header, req);
    }

    private static AdyenSaleToPOIRequest createRequest(AdyenMessageHeader header, AdyenPaymentRequest req) {
        AdyenSaleToPOIRequest aReq = new AdyenSaleToPOIRequest();
        aReq.setMessageHeader(header);
        aReq.setPaymentRequest(req);
        return aReq;
    }

    private static AdyenPOITxnID createPOITxnID(String t, String Id2) {
        AdyenPOITxnID poi = new AdyenPOITxnID();
        poi.setTransactionID(Id2);
        poi.setTimeStamp(t);
        return poi;
    }

    public static String getDataProperty(AdyenSaleToPOIResponse r, String property) {
        if (r.getPaymentResponse() != null) {
            return AdyenOPayUtils.getDataPropertyValue(property, r.getPaymentResponse().getResponse().getAdditionalResponse());
        }
        if (r.getReversalResponse() != null) {
            return AdyenOPayUtils.getDataPropertyValue(property, r.getReversalResponse().getResponse().getAdditionalResponse());
        }
        if (r.getCardAcquisitionResponse() != null) {
            return AdyenOPayUtils.getDataPropertyValue(property, r.getCardAcquisitionResponse().getResponse().getAdditionalResponse());
        }
        return "";
    }

    private static String getDataPropertyValue(String property, String additionalResponse) {
        String[] properties;
        for (String prop : properties = additionalResponse.split("&")) {
            if (!prop.split("=")[0].equals(property)) continue;
            return prop.split("=")[1];
        }
        return null;
    }

    public static String createCardNoteString(AdyenPaymentResponse r, boolean maskStart) {
        try {
            if (r.getPaymentResult() == null || r.getPaymentResult().getPaymentInstrumentData() == null) {
                return "";
            }
            String cardData = r.getPaymentResult().getPaymentInstrumentData().getCardData().getMaskedPan();
            if (maskStart) {
                int index = 0;
                while (cardData.charAt(index) != '*') {
                    cardData = cardData.replaceFirst("" + cardData.charAt(index), "*");
                    ++index;
                }
            }
            cardData = cardData.replaceAll(" ", "*");
            int indexStart = 3;
            for (int i = 0; i < cardData.length(); ++i) {
                if (cardData.indexOf(i) == 42 || cardData.indexOf(i) == 32 || i != indexStart) continue;
                cardData = cardData.substring(0, indexStart + 1) + " " + cardData.substring(indexStart + 1);
                indexStart += 5;
            }
            return cardData;
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error extracting masked pan", (Throwable)ex);
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FinanceUnit getFinanceUnitFor(PaTPaymentResult payment) {
        FinanceUnit unit = null;
        List<Pair<String, FinanceUnit>> list = uuidTypes;
        synchronized (list) {
            Pair<String, FinanceUnit> found = null;
            for (Pair<String, FinanceUnit> uuidType : uuidTypes) {
                if (!((String)uuidType.key).equals(payment.getTransactionUuid())) continue;
                found = uuidType;
                break;
            }
            if (found != null) {
                unit = (FinanceUnit)found.value;
                uuidTypes.remove(found);
            }
        }
        return unit;
    }
}

