/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.adyen;

import au.com.ordermate.gui.DummyGUIHandler;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Pair;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.xmlintegration.adyen.AdyenMessage;
import au.com.ordermate.xmlintegration.adyen.AdyenMessageHeader;
import au.com.ordermate.xmlintegration.adyen.AdyenPaymentData;
import au.com.ordermate.xmlintegration.adyen.AdyenSaleToPOIResponse;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationIntrospector;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.finance.FinanceSurchargeCalculator;
import ordermate.database.finance.transactions.CashTransaction;
import ordermate.database.finance.transactions.CreditTransaction;
import ordermate.database.finance.transactions.DebitTransaction;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.eftpos.EftposType;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.database.sales.Account;
import ordermate.database.sales.SimplePrintAccount;
import ordermate.database.sales.TableAccount;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.PhysicalTable;
import ordermate.database.users.User;
import ordermate.gui.SimpleSaveAccount;
import ordermate.integration.eftpos.adyen.AdyenIntegrationProcessor;
import ordermate.integration.eftpos.adyen.AdyenMarshaller;
import ordermate.integration.eftpos.adyen.AdyenUtils;
import ordermate.webresource.AbstractResource;
import ordermate.webresource.adyen.AdyenCashDrawerItem;
import ordermate.webresource.adyen.AdyenCashDrawersResponse;
import ordermate.webresource.adyen.AdyenOPayUtils;
import ordermate.webresource.adyen.AdyenTxnTerminalItem;
import ordermate.webresource.adyen.AdyenTxnTerminalsResponse;
import org.apache.logging.log4j.Level;

@Path(value="")
public class AdyenTransactionResource
extends AbstractResource {
    @GET
    @Produces(value={"application/json"})
    @Path(value="ping")
    public Response getPing() {
        return this.getResponse("[accepted]", Response.Status.OK, MediaType.APPLICATION_JSON_TYPE);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="terminals")
    public Response getTerminals() {
        List<VirtualEftpos> terminals = PersistenceManager.getObjectList(VirtualEftpos.class, Query.select(VirtualEftpos.class).active(VirtualEftpos.class).equals(VirtualEftpos.Properties.EFTPOS_TYPE, EftposType.ADYEN).toString());
        ArrayList<AdyenTxnTerminalItem> tList = new ArrayList<AdyenTxnTerminalItem>();
        for (VirtualEftpos t : terminals) {
            tList.add(new AdyenTxnTerminalItem(t.getLabel(), t.getTerminalId()));
        }
        AdyenTxnTerminalsResponse r = new AdyenTxnTerminalsResponse();
        r.setTerminals(tList.toArray(new AdyenTxnTerminalItem[tList.size()]));
        return this.getResponse(AdyenTransactionResource.toJson(r), Response.Status.OK, MediaType.APPLICATION_JSON_TYPE);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="cashdrawers")
    public Response getCashDrawers() {
        List<CashDrawer> cds = PersistenceManager.getObjectList(CashDrawer.class, Query.select(CashDrawer.class).active(CashDrawer.class).orderBy(CashDrawer.Properties.LABEL).toString());
        ArrayList<AdyenCashDrawerItem> tList = new ArrayList<AdyenCashDrawerItem>();
        tList.add(new AdyenCashDrawerItem("Default", 0L));
        for (CashDrawer t : cds) {
            tList.add(new AdyenCashDrawerItem(t.getLabel(), t.getID()));
        }
        AdyenCashDrawersResponse r = new AdyenCashDrawersResponse();
        r.setCashdrawers(tList.toArray(new AdyenCashDrawerItem[tList.size()]));
        return this.getResponse(AdyenTransactionResource.toJson(r), Response.Status.OK, MediaType.APPLICATION_JSON_TYPE);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="payattable")
    public Response performPayAtTableRequest(String entity) {
        OrderMate.LOG.info("Incoming Adyen PayAtTable Request for " + entity);
        AdyenMessage req = new AdyenMarshaller().unmarshal(entity, AdyenMessage.class);
        VirtualEftpos eftpos = PersistenceManager.getObject(VirtualEftpos.class, Query.select(VirtualEftpos.class).active(VirtualEftpos.class).equals(VirtualEftpos.Properties.EFTPOS_TYPE, EftposType.ADYEN).equals(VirtualEftpos.Properties.TERMINAL_ID, req.getSaleToPOIRequest().getMessageHeader().getPOIID()).toString());
        if (eftpos == null) {
            return this.getResponse("Terminal Id Not Found", Response.Status.BAD_REQUEST, MediaType.APPLICATION_JSON_TYPE);
        }
        if (eftpos.getCashDrawer() == null) {
            return this.getResponse("Terminal Not Connected To Cashdrawer", Response.Status.BAD_REQUEST, MediaType.APPLICATION_JSON_TYPE);
        }
        String reference = req.getSaleToPOIRequest().getEventNotification().getEventDetails();
        if (reference == null) {
            return this.getResponse("Table Reference Not Found", Response.Status.BAD_REQUEST, MediaType.APPLICATION_JSON_TYPE);
        }
        String idNumber = reference.split("=")[1];
        if (idNumber == null) {
            return this.getResponse("Table Reference Not Found", Response.Status.BAD_REQUEST, MediaType.APPLICATION_JSON_TYPE);
        }
        Account acc = PersistenceManager.getObject(TableAccount.class, Query.select(TableAccount.class).linkUsing(TableAccount.Properties.TABLE).linkUsing(LogicalTable.Properties.PRIMARY_PHYSICAL_TABLE).equals(TableAccount.Properties.ACCOUNT_STATE, "OPEN").equals(PhysicalTable.Properties.NAME, idNumber).active(PhysicalTable.class).toString());
        if (acc == null) {
            return this.getResponse("No Account Associated With Table", Response.Status.BAD_REQUEST, MediaType.APPLICATION_JSON_TYPE);
        }
        if (!acc.lock(User.getSystemUser()) || !acc.isLocked()) {
            OrderMate.LOG.warn("TyroMobileResource - Locking the account to process transaction, account ID: " + acc.getID());
            acc.unlock();
            acc.lock(User.getSystemUser());
        }
        String refId = this.createTransactionId();
        AdyenMessageHeader header = AdyenTransactionResource.createHeader(refId, "Payment", eftpos);
        AdyenMessage txnReq = new AdyenMessage();
        txnReq.setSaleToPOIRequest(AdyenUtils.createPaymentPOIRequest(header, refId, acc.getDue(), Price.ZERO_DOLLAR, Price.ZERO_DOLLAR));
        AdyenPaymentData data = new AdyenPaymentData();
        data.setPaymentType("Normal");
        data.setSplitPaymentFlag(true);
        txnReq.getSaleToPOIRequest().getPaymentRequest().setPaymentData(data);
        txnReq.getSaleToPOIRequest().getPaymentRequest().getPaymentTransaction().getAmountsReq().setPaidAmount(acc.getTotal().subtract(acc.getDue()).toBigDecimal());
        txnReq.getSaleToPOIRequest().setMessageHeader(header);
        AdyenMessage r = AdyenIntegrationProcessor.getInstance().doTransaction(txnReq, AdyenUtils.getAdyenTerminalIP(eftpos.isTesting()));
        FinanceTransaction txn = this.getFinanceTransaction(r, eftpos);
        acc.addFinanceTransaction(txn);
        if (txn.getSurcharge() != null) {
            OrderMate.LOG.info("Adyen PaT Resource - applying surcharge " + txn.getSurcharge());
            FinanceSurchargeCalculator.applySurcharge(acc, txn.getSubType(), txn.getSurcharge(), new EventContext(txn.getTerminal(), txn.getUser(), txn.getTradingDay(), txn.getShift()));
        }
        this.saveAccount(acc);
        acc.unlock();
        return this.getResponse("[approved]", Response.Status.OK, MediaType.APPLICATION_JSON_TYPE);
    }

    private void saveAccount(Account account) {
        SimpleSaveAccount simpleSaveAccount = new SimpleSaveAccount(new DummyGUIHandler(), new SimplePrintAccount());
        EventContext eventContext = new EventContext(Terminal.getServerMateTerminal(), User.getSystemUser());
        if (!simpleSaveAccount.closeAccount(account, true, true, eventContext)) {
            simpleSaveAccount.saveAccount(account, eventContext);
            OrderMate.LOG.info("The account " + account + " is saved, but it was unable to be closed.");
        }
    }

    private FinanceTransaction getFinanceTransaction(AdyenMessage r, VirtualEftpos virtualEftpos) {
        OrderMate.LOG.info("Wrangling finance transaction from Adyen Response");
        FinanceUnit financeUnit = AdyenUtils.containsDataProperty("cardType", r.getSaleToPOIResponse().getPaymentResponse().getResponse().getAdditionalResponse()) ? AdyenUtils.getCardTypeFromBrand(AdyenUtils.getDataProperty(r.getSaleToPOIResponse(), "cardType")) : FinanceUnit.getDefaultUnitFor(FinanceUnit.CASH_TYPE);
        CashDrawer cashDrawer = virtualEftpos.getCashDrawer();
        FinanceTransaction financeTran = null;
        Price totalAmount = this.calculateAmount(r.getSaleToPOIResponse());
        Price tipAmount = new Price(r.getSaleToPOIResponse().getPaymentResponse().getPaymentResult().getAmountsResp().getTipAmountSafe(), 0.01);
        AdyenPaymentMeta meta = this.getMetaData(r.getSaleToPOIResponse());
        OrderMate.LOG.info(meta.UUID + " has totalAmount " + totalAmount + " surcharge " + meta.surcharge + " tip " + tipAmount);
        financeTran = FinanceUnit.DEBIT_TYPE.toString().equals(financeUnit.getType()) ? new DebitTransaction(User.getSystemUser(), Terminal.getServerMateTerminal(), totalAmount, tipAmount, Price.ZERO_DOLLAR, cashDrawer, financeUnit, Terminal.getServerMateTerminal().getShift()) : (FinanceUnit.CREDIT_TYPE.toString().equals(financeUnit.getType()) ? new CreditTransaction(User.getSystemUser(), Terminal.getServerMateTerminal(), totalAmount, tipAmount, cashDrawer, financeUnit, Terminal.getServerMateTerminal().getShift()) : new CashTransaction(User.getSystemUser(), Terminal.getServerMateTerminal(), totalAmount, totalAmount, tipAmount, cashDrawer, Terminal.getServerMateTerminal().getShift()));
        if (meta.surcharge != null && !Price.ZERO_DOLLAR.equals(meta.surcharge)) {
            financeTran.setSurcharge(meta.surcharge);
        }
        if (!StringUtils.isEmpty(meta.UUID) && financeTran instanceof EftposTransaction) {
            financeTran.setTransactionReference(meta.UUID);
        }
        financeTran.setTransactionProcessed(true);
        if (financeTran instanceof EftposTransaction) {
            ((EftposTransaction)financeTran).setVirtualEftpos(virtualEftpos);
        }
        if (!r.getSaleToPOIResponse().getPaymentResponse().getResponse().getResult().equals("Success") && !r.getSaleToPOIResponse().getPaymentResponse().getResponse().getResult().equals("Partial")) {
            financeTran.setSystemState("DELETED");
        }
        return financeTran;
    }

    private String getDataValue(List<Pair<String, String>> pairs, String key) {
        for (Pair<String, String> pair : pairs) {
            if (!key.equals(pair.key)) continue;
            try {
                return (String)pair.value;
            }
            catch (Exception ex) {
                OrderMate.LOG.log(Level.WARN, "Cannot parse " + (String)pair.key + " with " + (String)pair.value);
                break;
            }
        }
        return null;
    }

    public static AdyenMessageHeader createHeader(String txnID, String type, VirtualEftpos vEft) {
        return AdyenUtils.createHeader("3.0", "Service", type, "Request", vEft.getMerchantId(), txnID, vEft.getTerminalId());
    }

    private String createTransactionId() {
        Long unixTime = System.currentTimeMillis();
        if (unixTime.toString().length() > 10) {
            return unixTime.toString().substring(unixTime.toString().length() - 10);
        }
        return unixTime.toString();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="lastTransaction/{terminalId}")
    public Response getLastTransaction(@PathParam(value="terminalId") String tid) {
        VirtualEftpos eftpos = PersistenceManager.getObject(VirtualEftpos.class, Query.select(VirtualEftpos.class).active(VirtualEftpos.class).equals(VirtualEftpos.Properties.EFTPOS_TYPE, EftposType.ADYEN).equals(VirtualEftpos.Properties.TERMINAL_ID, tid).toString());
        if (eftpos == null) {
            return this.getResponse("Terminal Id Not Found", Response.Status.BAD_REQUEST, MediaType.APPLICATION_JSON_TYPE);
        }
        AdyenMessageHeader header = AdyenUtils.createHeader("3.0", "Service", "TransactionStatus", "Request", eftpos.getMerchantId(), this.createTransactionId(), eftpos.getTerminalId());
        AdyenMessage adyenReq = new AdyenMessage();
        adyenReq.setSaleToPOIRequest(AdyenUtils.createTxnStatusPOIRequest(header));
        AdyenMessage r = AdyenIntegrationProcessor.getInstance().doTransaction(adyenReq, AdyenUtils.getAdyenTerminalIP(eftpos.isTesting()));
        return this.getResponse(new AdyenMarshaller().marshal(r), Response.Status.OK, MediaType.APPLICATION_JSON_TYPE);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="lastTransaction/{terminalId}/{serviceId}")
    public Response getLastTransactionWithId(@PathParam(value="terminalId") String tid, @PathParam(value="serviceId") String serviceId) {
        VirtualEftpos eftpos = PersistenceManager.getObject(VirtualEftpos.class, Query.select(VirtualEftpos.class).active(VirtualEftpos.class).equals(VirtualEftpos.Properties.EFTPOS_TYPE, EftposType.ADYEN).equals(VirtualEftpos.Properties.TERMINAL_ID, tid).toString());
        if (eftpos == null) {
            return this.getResponse("Terminal Id Not Found", Response.Status.BAD_REQUEST, MediaType.APPLICATION_JSON_TYPE);
        }
        AdyenMessageHeader header = AdyenUtils.createHeader("3.0", "Service", "TransactionStatus", "Request", eftpos.getMerchantId(), this.createTransactionId(), eftpos.getTerminalId());
        AdyenMessage adyenReq = new AdyenMessage();
        adyenReq.setSaleToPOIRequest(AdyenUtils.createTxnStatusPOIRequest(header, serviceId));
        AdyenMessage r = AdyenIntegrationProcessor.getInstance().doTransaction(adyenReq, AdyenUtils.getAdyenTerminalIP(eftpos.isTesting()));
        return this.getResponse(new AdyenMarshaller().marshal(r), Response.Status.OK, MediaType.APPLICATION_JSON_TYPE);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="transaction/{terminalId}")
    public Response performTransaction(@PathParam(value="terminalId") String tid, String entity) {
        OrderMate.LOG.info("Request to perform Adyen transaction " + tid + " with " + entity);
        AdyenMessage req = new AdyenMarshaller().unmarshal(entity, AdyenMessage.class);
        VirtualEftpos eftpos = PersistenceManager.getObject(VirtualEftpos.class, Query.select(VirtualEftpos.class).active(VirtualEftpos.class).equals(VirtualEftpos.Properties.EFTPOS_TYPE, EftposType.ADYEN).equals(VirtualEftpos.Properties.TERMINAL_ID, tid).toString());
        if (eftpos == null) {
            return this.getResponse("Terminal Id Not Found", Response.Status.BAD_REQUEST, MediaType.APPLICATION_JSON_TYPE);
        }
        AdyenMessageHeader header = AdyenTransactionResource.createHeader(req.getSaleToPOIRequest().getPaymentRequest().getSaleData().getSaleTransactionID().getTransactionID(), "Payment", eftpos);
        req.getSaleToPOIRequest().setMessageHeader(header);
        req.getSaleToPOIRequest().getPaymentRequest().getSaleData().setSaleToAcquirerData(AdyenUtils.createSaleToAcquirerData(req.getSaleToPOIRequest().getPaymentRequest().getSaleData().getSaleToAcquirerData()));
        AdyenMessage r = AdyenIntegrationProcessor.getInstance().doTransaction(req, AdyenUtils.getAdyenTerminalIP(eftpos.isTesting()));
        OrderMate.LOG.info("Adyen payment finished");
        try {
            FinanceUnit unit;
            AdyenPaymentMeta meta = this.getMetaData(r.getSaleToPOIResponse());
            if (!StringUtils.isEmpty(meta.UUID) && AdyenUtils.containsDataProperty("cardType", r.getSaleToPOIResponse().getPaymentResponse().getResponse().getAdditionalResponse()) && (unit = AdyenUtils.getCardTypeFromBrand(AdyenUtils.getDataProperty(r.getSaleToPOIResponse(), "cardType"))) != null) {
                AdyenOPayUtils.addTypeToUUID(meta.UUID, unit);
                OrderMate.LOG.info(meta.UUID + " resolved to " + unit);
            }
            if (meta.surcharge != null) {
                OrderMate.LOG.info("Applying surcharge to totalFeesAmount " + meta.surcharge);
                r.getSaleToPOIResponse().getPaymentResponse().getPaymentResult().getAmountsResp().setTotalFeesAmount(meta.surcharge.toBigDecimal());
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.log(Level.ERROR, "Cannot apply surcharge");
        }
        String stringResponse = new AdyenMarshaller().marshal(r);
        OrderMate.LOG.info("String Response " + stringResponse);
        return this.getResponse(stringResponse, Response.Status.OK, MediaType.APPLICATION_JSON_TYPE);
    }

    private Price calculateAmount(AdyenSaleToPOIResponse resp) {
        Price temp = new Price(resp.getPaymentResponse().getPaymentResult().getAmountsResp().getAuthorizedAmount(), 0.01);
        temp = temp.subtract(new Price(resp.getPaymentResponse().getPaymentResult().getAmountsResp().getTipAmountSafe(), 0.01));
        temp = temp.subtract(new Price(resp.getPaymentResponse().getPaymentResult().getAmountsResp().getCashBackAmountSafe(), 0.01));
        return temp;
    }

    public static String toJson(Object obj) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper = mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
            mapper = mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
            mapper = mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            JaxbAnnotationIntrospector introspector = new JaxbAnnotationIntrospector(mapper.getTypeFactory());
            mapper.setAnnotationIntrospector((AnnotationIntrospector)introspector);
            String result = mapper.writeValueAsString(obj);
            return result;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private AdyenPaymentMeta getMetaData(AdyenSaleToPOIResponse resp) {
        AdyenPaymentMeta meta = new AdyenPaymentMeta();
        BigDecimal value = null;
        if (value == null) {
            try {
                String additional = resp.getPaymentResponse().getResponse().getAdditionalResponse();
                String fromUrl = AdyenUtils.cleanHTMLCharacters(additional);
                List<Pair<String, String>> pairs = StringUtils.splitToPairs(fromUrl, "=", "&");
                int original = this.safeInt(this.getDataValue(pairs, "posOriginalAmountValue"));
                int auth = this.safeInt(this.getDataValue(pairs, "posAuthAmountValue"));
                int gratuity = this.safeInt(this.getDataValue(pairs, "posAmountGratuityValue"));
                int surcharge = auth - original - gratuity;
                String uuid = this.getDataValue(pairs, "pspReference");
                OrderMate.LOG.log(Level.INFO, "For UUID:" + uuid + " orig:" + original + " auth:" + auth + " grat:");
                OrderMate.LOG.log(Level.INFO, "Applying surcharge in cents:" + surcharge);
                if (surcharge > 0) {
                    value = new BigDecimal(surcharge);
                    value = value.scaleByPowerOfTen(-2);
                } else if (surcharge < 0) {
                    OrderMate.LOG.log(Level.WARN, "Cannot get a negative surcharge?" + value);
                }
            }
            catch (Exception ex) {
                OrderMate.LOG.log(Level.ERROR, "Cannot wrangle surcharge", (Throwable)ex);
            }
        }
        if (value != null) {
            meta.surcharge = new Price(value, 0.01);
        }
        return meta;
    }

    private int safeInt(String value) {
        if (!StringUtils.isEmpty(value)) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception ex) {
                OrderMate.LOG.log(Level.ERROR, "Cannot parse integer " + value, (Throwable)ex);
            }
        }
        return 0;
    }

    private class AdyenPaymentMeta {
        private Price surcharge = Price.ZERO_DOLLAR;
        private String UUID;

        private AdyenPaymentMeta() {
        }
    }
}

