/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.bartabs;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.Payable;
import ordermate.database.finance.FinanceSurchargeCalculator;
import ordermate.database.finance.transactions.CashTransaction;
import ordermate.database.finance.transactions.CreditTransaction;
import ordermate.database.finance.transactions.DebitTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.finance.transactions.WebTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.integration.bartabs.BarTabsConfiguration;
import ordermate.database.sales.Account;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.users.User;
import ordermate.integration.bartabs.BarTabIntegrationHelper;
import ordermate.integration.bartabs.BarTabSettlementResult;
import ordermate.webresource.bartabs.BarTabsResourceException;
import ordermate.webresource.bartabs.BarTabsResultCode;

public class BarTabIntegrationManager {
    private static BarTabIntegrationManager instance;

    public static synchronized BarTabIntegrationManager getInstance() {
        if (instance == null) {
            instance = new BarTabIntegrationManager();
        }
        return instance;
    }

    public synchronized BarTabAccount openBarTabAccount(String barTabName, double creditLimit, String extID, String vendorId) throws BarTabsResourceException {
        if (barTabName == null) {
            throw new BarTabsResourceException(BarTabsResultCode.BAR_TAB_NAME_NOT_GIVEN);
        }
        BarTabAccount acc = new BarTabAccount(User.getSystemUser(), Terminal.getServerMateTerminal(), barTabName);
        acc.setSource(vendorId);
        acc.setExtID(extID);
        acc.setCreditLimit(new Price(creditLimit, 0.01));
        this.saveAccount(acc);
        return (BarTabAccount)PersistenceManager.reacquire(acc);
    }

    public synchronized BarTabSettlementResult barTabPayment(String vendorId, String posBarTabId, String extBarTabId, Price pay, Price tip) throws BarTabsResourceException {
        return this.barTabPayment(vendorId, posBarTabId, extBarTabId, pay, tip, Price.ZERO_DOLLAR, User.getSystemUser());
    }

    public synchronized BarTabSettlementResult barTabPayment(String vendorId, String posBarTabId, String extBarTabId, Price pay, Price tip, Price surcharge) throws BarTabsResourceException {
        return this.barTabPayment(vendorId, posBarTabId, extBarTabId, pay, tip, surcharge, User.getSystemUser());
    }

    public synchronized BarTabSettlementResult barTabPayment(String vendorId, String posBarTabId, String extBarTabId, Price pay, Price tip, Price surcharge, User user) throws BarTabsResourceException {
        BarTabAccount barTab = BarTabIntegrationHelper.getBarTabFromExtId(vendorId, extBarTabId, posBarTabId);
        if (barTab == null) {
            throw new BarTabsResourceException(BarTabsResultCode.BAR_TAB_NOT_FOUND);
        }
        if (!barTab.isOpen()) {
            throw new BarTabsResourceException(BarTabsResultCode.ERROR_BARTAB_ALREADY_CLOSED);
        }
        Terminal term = Terminal.getLocalHost();
        User userToUse = user == null ? User.getSystemUser() : user;
        try {
            CashDrawer drawer = CashDrawer.getOfficeCashDrawer(term, userToUse);
            CashDrawer.checkTerminalCanUseCashDrawer(drawer, term, userToUse);
            FinanceUnit unit = BarTabsConfiguration.getBarTabConfigForVendorId(vendorId).getFinanceUnit();
            FinanceTransaction financeTransaction = this.getFinanceTransactionForPayment(unit, term, drawer, userToUse, pay, tip);
            if (surcharge != null && !surcharge.isZero() && FinanceSurchargeCalculator.shouldApplyPreSurcharge(financeTransaction)) {
                financeTransaction.setSurcharge(surcharge);
                FinanceSurchargeCalculator.applySurcharge(barTab, financeTransaction.getSubType(), surcharge, new EventContext(Terminal.getServerMateTerminal(), User.getSystemUser()));
            }
            if (financeTransaction == null) {
                throw new IllegalStateException("FinanceTransaction was not created.");
            }
            financeTransaction.setTransactionProcessed(true);
            barTab.addFinanceTransaction(financeTransaction);
            this.saveAccount(barTab, userToUse);
            return new BarTabSettlementResult(true, financeTransaction);
        }
        catch (BarTabsResourceException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new BarTabsResourceException(BarTabsResultCode.ERROR_ADDING_FINANCE_TRANS);
        }
    }

    public synchronized BarTabSettlementResult barTabPayment(BarTabAccount barTab, Price pay, Price tip, Price surcharge, User user) throws BarTabsResourceException {
        if (!barTab.isOpen()) {
            throw new BarTabsResourceException(BarTabsResultCode.ERROR_BARTAB_ALREADY_CLOSED);
        }
        Terminal term = Terminal.getLocalHost();
        User userToUse = user == null ? User.getSystemUser() : user;
        try {
            CashDrawer drawer = CashDrawer.getOfficeCashDrawer(term, userToUse);
            CashDrawer.checkTerminalCanUseCashDrawer(drawer, term, userToUse);
            FinanceUnit unit = BarTabsConfiguration.getBarTabConfigForVendorId(barTab.getSource()).getFinanceUnit();
            FinanceTransaction financeTransaction = this.getFinanceTransactionForPayment(unit, term, drawer, userToUse, pay, tip);
            if (surcharge != null && !surcharge.isZero() && FinanceSurchargeCalculator.shouldApplyPreSurcharge(financeTransaction)) {
                financeTransaction.setSurcharge(surcharge);
                FinanceSurchargeCalculator.applySurcharge(barTab, financeTransaction.getSubType(), surcharge, new EventContext(Terminal.getServerMateTerminal(), User.getSystemUser()));
            }
            if (financeTransaction == null) {
                throw new IllegalStateException("FinanceTransaction was not created.");
            }
            financeTransaction.setTransactionProcessed(true);
            barTab.addFinanceTransaction(financeTransaction);
            return new BarTabSettlementResult(true, financeTransaction);
        }
        catch (Exception e) {
            OrderMate.LOG.error((Object)e);
            throw new BarTabsResourceException(BarTabsResultCode.ERROR_ADDING_FINANCE_TRANS);
        }
    }

    public synchronized BarTabAccount closeBarTabAccount(String vendorId, String posBarTabId, String extBarTabId) throws BarTabsResourceException {
        BarTabAccount barTab = BarTabIntegrationHelper.getBarTabFromExtId(vendorId, extBarTabId, posBarTabId);
        if (barTab == null) {
            throw new BarTabsResourceException(BarTabsResultCode.BAR_TAB_NOT_FOUND);
        }
        this.canCloseAccount(barTab);
        barTab.close(new EventContext(Terminal.getServerMateTerminal(), User.getSystemUser()));
        this.saveAccount(barTab);
        return (BarTabAccount)PersistenceManager.reacquire(barTab);
    }

    public synchronized BarTabAccount updateBarTabLimit(String vendorId, String posBarTabId, String extBarTabId, Price newLimit) throws BarTabsResourceException {
        BarTabAccount barTab = BarTabIntegrationHelper.getBarTabFromExtId(vendorId, extBarTabId, posBarTabId);
        if (barTab == null) {
            throw new BarTabsResourceException(BarTabsResultCode.BAR_TAB_NOT_FOUND);
        }
        if (barTab.getDue().greaterThan(newLimit)) {
            throw new BarTabsResourceException(BarTabsResultCode.BAR_TAB_LIMIT_LESS_THAN_DUE);
        }
        barTab.setCreditLimit(newLimit);
        this.saveAccount(barTab);
        return (BarTabAccount)PersistenceManager.reacquire(barTab);
    }

    public void checkVendorId(String vendorId) throws BarTabsResourceException {
        if (BarTabsConfiguration.getBarTabConfigForVendorId(vendorId) == null) {
            throw new BarTabsResourceException(BarTabsResultCode.UNKNOWN_VENDOR_ID);
        }
    }

    private void saveAccount(Account account) throws BarTabsResourceException {
        this.saveAccount(account, User.getSystemUser());
    }

    private void saveAccount(Account account, User user) throws BarTabsResourceException {
        if (!account.isLocked(user) && !account.lock(user)) {
            throw new BarTabsResourceException(BarTabsResultCode.ERROR_BARTAB_LOCKED_BY_ANOTHER_USER);
        }
        try {
            account.save();
        }
        finally {
            account.unlock();
        }
    }

    private FinanceTransaction getFinanceTransactionForPayment(FinanceUnit unit, Terminal term, CashDrawer drawer, User user, Price paid, Price tip) {
        if ("CASH".equals(unit.getType())) {
            return new CashTransaction(user, term, paid, paid, Price.ZERO_DOLLAR, drawer, term.getShift());
        }
        if ("CREDIT".equals(unit.getType())) {
            return new CreditTransaction(user, term, paid, tip, drawer, unit, term.getShift());
        }
        if ("DEBIT".equals(unit.getType())) {
            return new DebitTransaction(user, term, paid, tip, Price.ZERO_DOLLAR, drawer, unit, term.getShift());
        }
        return new WebTransaction(user, term, paid, tip, drawer, unit, term.getShift());
    }

    private void canCloseAccount(Account account) throws BarTabsResourceException {
        if (!account.isOpen()) {
            throw new BarTabsResourceException(BarTabsResultCode.ERROR_BARTAB_ALREADY_CLOSED);
        }
        if (!account.isClosePossible()) {
            throw new BarTabsResourceException(BarTabsResultCode.ERROR_BARTAB_CANNOT_BE_CLOSED);
        }
        Payable.PaidState paidState = account.getPaidState();
        if (paidState.equals(Payable.NOT_PAID)) {
            throw new BarTabsResourceException(BarTabsResultCode.BAR_TAB_NOT_PAID);
        }
        if (paidState.equals(Payable.CREDIT) || paidState.equals(Payable.UNPAYABLE) || paidState.equals(Payable.PAID) || paidState.equals(Payable.UNPAYABLE_BY_ROUNDING)) {
            return;
        }
        throw new BarTabsResourceException(BarTabsResultCode.ERROR_BARTAB_CANNOT_BE_CLOSED);
    }
}

