/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.bartabs;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import java.util.Date;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import ordermate.OrderMate;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.SalesItem;
import ordermate.integration.bartabs.BarTabIntegrationHelper;
import ordermate.integration.jaxb.bartabs.BarTab;
import ordermate.integration.jaxb.bartabs.BarTabItem;
import ordermate.integration.jaxb.bartabs.BarTabItemList;
import ordermate.integration.jaxb.bartabs.BarTabList;
import ordermate.integration.jaxb.bartabs.BarTabRequest;
import ordermate.integration.jaxb.bartabs.BarTabState;
import ordermate.integration.jaxb.bartabs.BarTabsResult;
import ordermate.webresource.WebResourceHelper;
import ordermate.webresource.bartabs.BarTabIntegrationManager;
import ordermate.webresource.bartabs.BarTabsResourceException;
import ordermate.webresource.bartabs.BarTabsResourceHelper;
import ordermate.webresource.bartabs.BarTabsResultCode;

@Path(value="")
public class BarTabsResource {
    @POST
    @Consumes(value={"application/xml"})
    @Produces(value={"application/xml"})
    @Path(value="/openbartab")
    public BarTabsResult openBarTab(BarTabRequest barTabRequest) {
        try {
            BarTabIntegrationManager.getInstance().checkVendorId(barTabRequest.getVendorId());
            BarTabAccount acc = BarTabIntegrationManager.getInstance().openBarTabAccount(barTabRequest.getName(), barTabRequest.getLimit().doubleValue(), barTabRequest.getExternalId(), barTabRequest.getVendorId());
            BarTabsResult requestResult = BarTabsResourceHelper.getSuccessResult();
            BarTabList barTabList = new BarTabList();
            barTabList.getBarTab().add(this.getBarTabWrapperFor(acc));
            requestResult.setBarTabList(barTabList);
            return requestResult;
        }
        catch (BarTabsResourceException ex) {
            return BarTabsResourceHelper.getBarTabsResult(ex.getResultCode());
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error occured within openBarTab method: ", (Throwable)ex);
            OrderMate.LOG.info("Original BarTabRequest: " + barTabRequest);
            return BarTabsResourceHelper.getInternalErrorResult();
        }
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/querybartabs")
    public BarTabsResult queryBarTabs(@QueryParam(value="vendorid") String vendorId, @QueryParam(value="modtime") String modTime, @QueryParam(value="posbartabid") String posBarTabId, @QueryParam(value="extbartabid") String extBarTabId) {
        try {
            BarTabIntegrationManager.getInstance().checkVendorId(vendorId);
            WebResourceHelper helper = new WebResourceHelper();
            Date actualModTime = helper.convertLongStringToDate(modTime);
            ObjectQuery query = Query.select(BarTabAccount.class).equals(BarTabAccount.Properties.SOURCE, vendorId);
            if (modTime != null) {
                query = query.greaterThan(BarTabAccount.Properties.MOD_DATE_TIME, actualModTime, SQLDateType.TIMESTAMP);
            } else if (posBarTabId == null && extBarTabId == null) {
                actualModTime = TradingDay.getCurrentTradingDay().getTime();
                query = query.greaterThan(BarTabAccount.Properties.MOD_DATE_TIME, actualModTime, SQLDateType.TIME);
            }
            if (posBarTabId != null) {
                query = query.equals(BarTabAccount.Properties.ID, posBarTabId);
            }
            if (extBarTabId != null) {
                query = query.equals(BarTabAccount.Properties.EXT_ID, extBarTabId);
            }
            List<BarTabAccount> accountsList = PersistenceManager.getObjectList(BarTabAccount.class, query.toString());
            BarTabsResult requestResult = BarTabsResourceHelper.getSuccessResult();
            BarTabList barTabList = new BarTabList();
            for (BarTabAccount acc : accountsList) {
                barTabList.getBarTab().add(this.getBarTabWrapperFor(acc));
            }
            requestResult.setBarTabList(barTabList);
            return requestResult;
        }
        catch (BarTabsResourceException ex) {
            return BarTabsResourceHelper.getBarTabsResult(ex.getResultCode());
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error occured within querybartabs method: ", (Throwable)ex);
            return BarTabsResourceHelper.getInternalErrorResult();
        }
    }

    @POST
    @Produces(value={"application/xml"})
    @Path(value="/bartabpayment")
    public BarTabsResult barTabPayment(@QueryParam(value="vendorid") String vendorId, @QueryParam(value="posbartabid") String posBarTabId, @QueryParam(value="extbartabid") String extBarTabId, @QueryParam(value="pay") String pay, @QueryParam(value="tip") String tip) {
        try {
            BarTabIntegrationManager.getInstance().checkVendorId(vendorId);
            if ((posBarTabId == null || posBarTabId.isEmpty()) && (extBarTabId == null || extBarTabId.isEmpty())) {
                return BarTabsResourceHelper.getBarTabsResult(BarTabsResultCode.BAR_TAB_NOT_IDENTIFIED);
            }
            if (pay == null) {
                return BarTabsResourceHelper.getBarTabsResult(BarTabsResultCode.PAY_PARAM_MISSING);
            }
            Price amountToPay = new Price(Double.parseDouble(pay) / 100.0, 0.01);
            Price amountToTip = Price.ZERO_NO_ROUND;
            if (tip != null) {
                amountToTip = new Price(Double.parseDouble(tip) / 100.0, 0.01);
            }
            BarTabIntegrationManager.getInstance().barTabPayment(vendorId, posBarTabId, extBarTabId, amountToPay, amountToTip);
            return this.getSuccessResultWithAccount(BarTabIntegrationHelper.getBarTabFromExtId(vendorId, extBarTabId, posBarTabId));
        }
        catch (BarTabsResourceException ex) {
            return BarTabsResourceHelper.getBarTabsResult(ex.getResultCode());
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error occured within bartabpayment method: ", (Throwable)ex);
            return BarTabsResourceHelper.getInternalErrorResult();
        }
    }

    @POST
    @Produces(value={"application/xml"})
    @Path(value="/closebartab")
    public BarTabsResult closeBarTab(@QueryParam(value="vendorid") String vendorId, @QueryParam(value="posbartabid") String posBarTabId, @QueryParam(value="extbartabid") String extBarTabId) {
        try {
            BarTabIntegrationManager.getInstance().checkVendorId(vendorId);
            if ((posBarTabId == null || posBarTabId.isEmpty()) && (extBarTabId == null || extBarTabId.isEmpty())) {
                return BarTabsResourceHelper.getBarTabsResult(BarTabsResultCode.BAR_TAB_NOT_IDENTIFIED);
            }
            BarTabAccount acc = BarTabIntegrationManager.getInstance().closeBarTabAccount(vendorId, posBarTabId, extBarTabId);
            return this.getSuccessResultWithAccount(acc);
        }
        catch (BarTabsResourceException ex) {
            return BarTabsResourceHelper.getBarTabsResult(ex.getResultCode());
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error occured within closebartab method: ", (Throwable)ex);
            return BarTabsResourceHelper.getInternalErrorResult();
        }
    }

    private BarTab getBarTabWrapperFor(BarTabAccount barTabAccount) {
        BarTab barTab = new BarTab();
        barTab.setDiscount(barTabAccount.getPriceAdjHelper().getDiscountTotal().toBigDecimal());
        barTab.setSurcharge(barTabAccount.getPriceAdjHelper().getSurchargeTotal().toBigDecimal());
        barTab.setBalance(barTabAccount.getDue().toBigDecimal());
        barTab.setId(barTabAccount.getID());
        barTab.setLimit(barTabAccount.getCreditLimit().toBigDecimal());
        barTab.setExternalId(barTabAccount.getExtID());
        barTab.setPayment(barTabAccount.getPaid().toBigDecimal());
        barTab.setTotal(barTabAccount.getTotal().toBigDecimal());
        barTab.setTax(barTabAccount.getTax().toBigDecimal());
        Price tip = Price.ZERO_DOLLAR;
        for (FinanceTransaction trans : barTabAccount.getFinanceTransactions()) {
            if (trans.getTip().isZero()) continue;
            tip = tip.add(trans.getTip());
        }
        barTab.setTip(tip.toBigDecimal());
        barTab.setState(barTabAccount.isOpen() ? BarTabState.OPEN : BarTabState.CLOSED);
        barTab.setBarTabItemList(this.getBarTabItemListForAccount(barTabAccount));
        try {
            WebResourceHelper helper = new WebResourceHelper();
            barTab.setCreationDate(helper.makeDateTime(barTabAccount.getCreationDateTime()));
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Error occurred converting the account creation date: " + barTabAccount.getCreationDateTime());
        }
        return barTab;
    }

    private BarTabItemList getBarTabItemListForAccount(BarTabAccount barTabAccount) {
        BarTabItemList itemList = new BarTabItemList();
        for (SalesItem item : barTabAccount.getItemHelper().getSalesItems()) {
            BarTabItem barTabItem = new BarTabItem();
            barTabItem.setDescription(item.getLabel());
            barTabItem.setId(item.getID());
            barTabItem.setPrice(item.getPrice().toBigDecimal());
            barTabItem.setQty(item.getQuantity().getValue());
            barTabItem.setTax(item.getTax().toBigDecimal());
            itemList.getBarTabItem().add(barTabItem);
        }
        return itemList;
    }

    private BarTabsResult getSuccessResultWithAccount(BarTabAccount barTabAccount) {
        BarTabsResult requestResult = BarTabsResourceHelper.getSuccessResult();
        BarTabList barTabList = new BarTabList();
        barTabList.getBarTab().add(this.getBarTabWrapperFor(barTabAccount));
        requestResult.setBarTabList(barTabList);
        return requestResult;
    }
}

