/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.customers;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.FinanceUtils;
import au.com.ordermate.util.Price;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.CustomerCategory;
import ordermate.database.sales.OnlineAccount;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesPriceAdjustmentUsage;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.usage.PersistentStockUsage;
import ordermate.integration.jaxb.webservice.customer.CustomerCategoryEntry;
import ordermate.integration.jaxb.webservice.customer.CustomerEntry;
import ordermate.integration.jaxb.webservice.customer.CustomerSalesComponentEntry;
import ordermate.integration.jaxb.webservice.customer.CustomerSalesList;
import ordermate.integration.jaxb.webservice.customer.ObjectFactory;
import ordermate.integration.jaxb.webservice.customer.PriceAdjustmentEntry;
import ordermate.integration.jaxb.webservice.customer.StockAreaEntry;
import ordermate.webresource.WebResourceExporter;

public class CustomerSalesExporter
extends WebResourceExporter<CustomerSalesList> {
    private final ObjectFactory factory = new ObjectFactory();

    public CustomerSalesList createCustomerList(String from, String to, Long stockAreaId) {
        return this.createCustomerList(from, to, stockAreaId, null, null);
    }

    public CustomerSalesList createCustomerList(String from, String to, Long stockAreaId, Boolean allCustomers, Boolean includeAnonymous) {
        if (this.helper == null) {
            OrderMate.LOG.warn("Helper not present, cannot export customers.");
            return this.factory.createCustomerSalesList();
        }
        Date fromDate = this.helper.convertLongStringToDate(from);
        Date toDate = this.helper.convertLongStringToDate(to);
        boolean exportAllCustomers = allCustomers != null && allCustomers != false;
        CustomerSalesList exportList = this.factory.createCustomerSalesList();
        exportList.setBusinessName(BusinessInfo.getInstance().getName());
        exportList.setFromDate(this.helper.makeDateTime(fromDate));
        exportList.setToDate(this.helper.makeDateTime(toDate));
        exportList.setArea(stockAreaId);
        this.makeStockAreas(exportList);
        this.makeCustomerCategories(exportList);
        StockArea area = null;
        if (stockAreaId != null && stockAreaId > 0L) {
            area = PersistenceManager.getByID(stockAreaId, StockArea.class);
        }
        this.makeCustomersSalesList(exportList, fromDate, toDate, area, exportAllCustomers, includeAnonymous);
        return exportList;
    }

    private void makeCustomersSalesList(CustomerSalesList exportList, Date from, Date to, StockArea stockArea, boolean exportAllCustomers, Boolean includeAnonymous) {
        List<Customer> customers;
        int batchSize = 1000;
        int offset = 0;
        ObjectQuery baseQuery = exportAllCustomers ? Query.select(Customer.class).active(Customer.class).orderBy(Customer.Properties.LAST_NAME).orderBy(Customer.Properties.FIRST_NAME) : Customer.getAllCustomersWithSales(from, to);
        OrderMate.LOG.info("Running customer list in batches of " + batchSize);
        do {
            ObjectQuery query = baseQuery.copy();
            query.limit(batchSize, offset);
            customers = PersistenceManager.getObjectList(Customer.class, query.toString());
            for (Customer nextCustomer : customers) {
                CustomerEntry exportCustomer = this.populateCustomer(nextCustomer);
                this.makeCustomerSalesComponents(exportCustomer, nextCustomer, from, to, stockArea);
                exportList.getCustomer().add(exportCustomer);
            }
            offset += batchSize;
        } while (!customers.isEmpty());
        if (Boolean.TRUE.equals(includeAnonymous)) {
            CustomerEntry fakeyBoi = new CustomerEntry();
            fakeyBoi.setCustomerId(-1L);
            fakeyBoi.setFirstName("<Anonymous>");
            this.makeCustomerSalesComponents(fakeyBoi, null, from, to, stockArea);
            exportList.getCustomer().add(fakeyBoi);
        }
        OrderMate.LOG.info("Customers went to " + offset);
    }

    private CustomerEntry populateCustomer(Customer customer) {
        CustomerEntry customerEntry = this.factory.createCustomerEntry();
        customerEntry.setActive("ACTIVE".equals(customer.getSystemState()));
        if (customer.getCategory() != null) {
            customerEntry.setCategory(customer.getCategory().getID());
        } else {
            customerEntry.setCategory(CustomerCategory.getDefaultCategory().getID());
        }
        customerEntry.setDateOfBirth(this.helper.makeDate(customer.getDOB()));
        customerEntry.setFirstName(customer.getFirstName());
        customerEntry.setLastName(customer.getLastName());
        customerEntry.setPostcode(customer.getPostcode());
        customerEntry.setState(customer.getState());
        customerEntry.setSuburb(customer.getSuburb());
        customerEntry.setTitle(customer.getTitle());
        customerEntry.setLoyaltyPoints(BigInteger.valueOf(customer.getLoyaltyPoints()));
        customerEntry.setEmail(customer.getEmail());
        customerEntry.setCardId(customer.getCardID());
        customerEntry.setCustomerId(customer.getID());
        customerEntry.setHouseNumber(customer.getHouseNumber());
        customerEntry.setPrimaryPhone(customer.getPrimaryPhoneNumber());
        customerEntry.setReceiveMarketing(customer.getReceiveMarketing());
        customerEntry.setSecondaryPhone(customer.getSecondaryPhoneNumber());
        customerEntry.setStreetDirRef(customer.getStreetDirRef());
        customerEntry.setStreetName(customer.getStreetName());
        customerEntry.setStreetType(customer.getStreetType());
        customerEntry.setCreationDate(this.helper.makeDate(customer.getCreationTime()));
        return customerEntry;
    }

    private void makeCustomerSalesComponents(CustomerEntry customerEntry, Customer customer, Date from, Date to, StockArea area) {
        Calendar calBuffer = Calendar.getInstance();
        calBuffer.setTime(from);
        calBuffer.add(5, -1);
        Date tdFrom = calBuffer.getTime();
        calBuffer.setTime(to);
        calBuffer.add(5, 1);
        Date tdTo = calBuffer.getTime();
        ObjectQuery sql = Query.select(SalesComponent.class).equals(Account.Properties.ACCOUNT_STATE, "CLOSED").linkUsing(SalesComponent.Properties.SALES_ITEM, SalesItem.Properties.ID).linkUsing(SalesItem.Properties.ACCOUNT, Account.Properties.ID).linkUsing(Account.Properties.TRADING_DAY, TradingDay.Properties.ID).wherePropertyBetween(Account.Properties.CREATION_DATE_TIME, from, to, SQLDateType.TIMESTAMP).greaterThanOrEqual(TradingDay.Properties.DATE, tdFrom, SQLDateType.DATE).lessThanOrEqual(TradingDay.Properties.DATE, tdTo, SQLDateType.DATE);
        if (customer != null) {
            sql.equals(SalesItem.Properties.CUSTOMER, customer);
        } else {
            sql.isNull(SalesItem.Properties.CUSTOMER);
        }
        if (area != null) {
            sql.joinLeft(PersistentStockUsage.class, SalesComponent.Properties.STOCK_USAGE).linkUsing(PersistentStockUsage.Properties.STOCK_AREA, StockArea.Properties.ID).equals(PersistentStockUsage.Properties.STOCK_AREA, area).lastFrom("sales_component");
        }
        List<SalesComponent> componentList = PersistenceManager.getObjectList(SalesComponent.class, sql.toString());
        ArrayList<CustomerSalesComponentEntry> entries = new ArrayList<CustomerSalesComponentEntry>();
        for (SalesComponent component : componentList) {
            CustomerSalesComponentEntry entry = this.factory.createCustomerSalesComponentEntry();
            SalesItem item = component.getSalesItem();
            entry.setAccountId(item.getAccount().getID());
            entry.setAccountType(item.getAccount().getAccountType().getLabel());
            entry.setItemId(component.getUnit().getID());
            entry.setItemCategory(component.getInventoryItem().getCategory().getLabel());
            entry.setComponentLabel(component.getUnit().getLabel());
            entry.setComponentId(component.getID());
            entry.setStockArea(area != null ? area.getID() : null);
            entry.setPortion(component.getUnit().getPortionLabel());
            entry.setOrderSource(item.getAccount() instanceof OnlineAccount ? ((OnlineAccount)item.getAccount()).getSource() : null);
            for (SalesItemQuantity qty : item.getSalesItemQuantities()) {
                if (item.getQuantity().equals(SalesQuantity.ZERO) || qty.getQuantity().equals(SalesQuantity.ZERO)) continue;
                entry.setFinalPrice(component.getSavedUnitPrice().multiply(qty.getQuantity()).toBigDecimal());
                entry.setQuantity(qty.getQuantity().getValue());
                entry.setWhenOrdered(this.helper.makeDateTime(qty.getCreationTime()));
                entry.setGrossProfit(FinanceUtils.calcGrossProfit(component.getSavedUnitPrice(), component.getTax(), component.getIngredientCostExTax()).multiply(qty.getQuantity()).toBigDecimal());
                this.makePriceAdjustments(item, qty, component, entry);
            }
            entries.add(entry);
        }
        customerEntry.getSalesComponent().addAll(entries);
    }

    private void makePriceAdjustments(SalesItem item, SalesItemQuantity qty, SalesComponent component, CustomerSalesComponentEntry entry) {
        List<SalesPriceAdjustmentUsage> usages = component.getPriceAdjustmentUsages();
        ArrayList<PriceAdjustmentEntry> adjs = new ArrayList<PriceAdjustmentEntry>();
        Price totalAdj = Price.ZERO_DOLLAR;
        for (SalesPriceAdjustmentUsage usage : usages) {
            PriceAdjustmentEntry adj = this.factory.createPriceAdjustmentEntry();
            adj.setAdjustmentId(usage.getSalesPriceAdjustment().getInventoryPriceAdjustment().getID());
            adj.setName(usage.getSalesPriceAdjustment().getLabel());
            Price value = usage.getSavedTotalValue().divide(item.getQuantity().getValue()).multiply(qty.getQuantity()).negate();
            adj.setValue(value.toBigDecimal());
            totalAdj = totalAdj.add(value);
            adjs.add(adj);
        }
        entry.getPriceAdjustment().addAll(adjs);
        entry.setTotalAdjustment(totalAdj.toBigDecimal());
        entry.setOriginalPrice(entry.getFinalPrice().subtract(totalAdj.toBigDecimal()));
    }

    private void makeStockAreas(CustomerSalesList exportList) {
        List<StockArea> allAreas = StockArea.getStockAreas();
        ArrayList<StockAreaEntry> stockAreaEntries = new ArrayList<StockAreaEntry>();
        for (StockArea area : allAreas) {
            StockAreaEntry entry = this.factory.createStockAreaEntry();
            entry.setStockareaId(area.getID());
            entry.setLabel(area.getLabel());
            entry.setIsActive(Boolean.TRUE);
            stockAreaEntries.add(entry);
        }
        exportList.getStockArea().addAll(stockAreaEntries);
    }

    private void makeCustomerCategories(CustomerSalesList exportList) {
        List<CustomerCategory> allCategories = CustomerCategory.getAllCategories();
        ArrayList<CustomerCategoryEntry> categories = new ArrayList<CustomerCategoryEntry>();
        for (CustomerCategory nextCategory : allCategories) {
            CustomerCategoryEntry entry = this.factory.createCustomerCategoryEntry();
            entry.setCategoryId(nextCategory.getID());
            entry.setLabel(nextCategory.getLabel());
            entry.setIsDefault(nextCategory.getIsDefault());
            entry.setIsActive("ACTIVE".equals(nextCategory.getSystemState()));
            categories.add(entry);
        }
        exportList.getCustomerCategory().addAll(categories);
    }

    @Override
    public String getName() {
        return "Customers";
    }

    @Override
    protected Class[] getBoundClasses() {
        return new Class[]{CustomerSalesComponentEntry.class, CustomerSalesList.class, CustomerCategoryEntry.class, PriceAdjustmentEntry.class};
    }

    public CustomerSalesList createCustomerModifiedList(String from, String to) {
        if (this.helper == null) {
            OrderMate.LOG.warn("Helper not present, cannot export customers.");
            return this.factory.createCustomerSalesList();
        }
        Date fromDate = this.helper.convertLongStringToDate(from);
        Date toDate = this.helper.convertLongStringToDate(to);
        CustomerSalesList exportList = this.factory.createCustomerSalesList();
        exportList.setBusinessName(BusinessInfo.getInstance().getName());
        exportList.setFromDate(this.helper.makeDateTime(fromDate));
        exportList.setToDate(this.helper.makeDateTime(toDate));
        exportList.setArea(null);
        this.makeStockAreas(exportList);
        this.makeCustomerCategories(exportList);
        ObjectQuery customerQuery = Query.select(Customer.class).active(Customer.class).orderBy(Customer.Properties.LAST_NAME).orderBy(Customer.Properties.FIRST_NAME).wherePropertyBetween(Customer.Properties.MOD, fromDate, toDate, SQLDateType.TIMESTAMP);
        for (Customer nextCustomer : PersistenceManager.getObjectList(Customer.class, customerQuery.toString())) {
            CustomerEntry exportCustomer = this.populateCustomer(nextCustomer);
            exportList.getCustomer().add(exportCustomer);
        }
        return exportList;
    }
}

