/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.diamondback;

import au.com.diamondback.xmlintegration.booking.DiamondBooking;
import au.com.diamondback.xmlintegration.booking.DiamondBookingPayment;
import au.com.diamondback.xmlintegration.booking.DiamondBookingState;
import au.com.diamondback.xmlintegration.booking.DiamondCustomer;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.sales.Customer;
import ordermate.database.sales.reservation.Reservation;
import ordermate.database.sales.reservation.ReservationDeposit;
import ordermate.database.tables.PhysicalTable;
import ordermate.database.tables.TableGroup;
import ordermate.webresource.diamondback.DiamondBackReservationArriver;
import ordermate.webresource.diamondback.DiamondBackReservationTransfer;
import org.apache.logging.log4j.Level;

class DiamondBackBookingHandler {
    private final DiamondBooking booking;
    private static final String localFormat = "yyyy-MM-dd'T'HH:mm:ss";

    DiamondBackBookingHandler(DiamondBooking booking) {
        this.booking = booking;
    }

    void processBooking() {
        Calendar bookingTime;
        Customer customer;
        Reservation res = null;
        if (!StringUtils.isEmpty(this.booking.getPosId())) {
            try {
                res = PersistenceManager.getByID(Long.valueOf(this.booking.getPosId()), Reservation.class);
            }
            catch (Exception ex) {
                OrderMate.LOG.log(Level.WARN, "Cannot retrieve booking with id " + this.booking.getPosId());
            }
        }
        if (res == null && !StringUtils.isEmpty(this.booking.getProvId())) {
            res = PersistenceManager.getObject(Reservation.class, Query.select(Reservation.class).equals(Reservation.Properties.EXTERNAL_ID, this.booking.getProvId()).toString());
        }
        DiamondCustomer dCust = this.booking.getCustomer();
        Customer customer2 = customer = res != null && res.getCustomer() != null ? res.getCustomer() : null;
        if (customer == null && dCust != null) {
            if (!StringUtils.isEmpty(dCust.getEmail())) {
                customer = PersistenceManager.getObject(Customer.class, Query.select(Customer.class).active(Customer.class).equals(Customer.Properties.E_MAIL, dCust.getEmail()).toString());
            } else if (!StringUtils.isEmpty(dCust.getFirstName()) && !StringUtils.isEmpty(dCust.getLastName())) {
                customer = PersistenceManager.getObject(Customer.class, Query.select(Customer.class).active(Customer.class).equals(Customer.Properties.FIRST_NAME, dCust.getFirstName()).equals(Customer.Properties.LAST_NAME, dCust.getLastName()).toString());
            } else if (!StringUtils.isEmpty(dCust.getPhone())) {
                customer = PersistenceManager.getObject(Customer.class, Query.select(Customer.class).active(Customer.class).equals(Customer.Properties.PRIMARY_PHONE_NUMBER, dCust.getPhone()).toString());
            }
            if (!(customer != null || StringUtils.isEmpty(dCust.getEmail()) && StringUtils.isEmpty(dCust.getPhone()) && StringUtils.isEmpty(dCust.getFirstName()))) {
                customer = new Customer();
                customer.setEmail(dCust.getEmail());
                customer.setFirstName(dCust.getFirstName());
                customer.setLastName(dCust.getLastName());
                customer.setPrimaryPhoneNumber(dCust.getPhone());
                customer.setComments(dCust.getNotes());
                customer.save();
            }
        }
        Date datePart = null;
        Date timePart = null;
        if (!StringUtils.isEmpty(this.booking.getLocalBookingDatetime())) {
            try {
                Date localDate = new SimpleDateFormat(localFormat).parse(this.booking.getLocalBookingDatetime());
                bookingTime = Calendar.getInstance();
                bookingTime.setTime(localDate);
            }
            catch (Exception ex) {
                OrderMate.LOG.warn("Cannot parse local booking time, defaulting to now", (Throwable)ex);
                bookingTime = Calendar.getInstance();
            }
        } else {
            bookingTime = this.booking.getBookingDatetime() != null ? this.booking.getBookingDatetime().toGregorianCalendar() : Calendar.getInstance();
        }
        datePart = bookingTime.getTime();
        datePart = DateTimeUtils.clearTimePart(datePart);
        timePart = bookingTime.getTime();
        timePart = DateTimeUtils.cleanDatePart(timePart);
        TableGroup tableGroup = null;
        if (this.booking.getTableSection() != null) {
            tableGroup = PersistenceManager.getObject(TableGroup.class, Query.select(TableGroup.class).equals(TableGroup.Properties.ONLINE, "0").equals(TableGroup.Properties.NAME, this.booking.getTableSection()).toString());
        }
        if (tableGroup == null) {
            tableGroup = this.determineTableGroup(this.booking.getTables());
        }
        if (res == null) {
            res = new Reservation(customer, timePart, datePart, this.booking.getNumPatrons() == null ? 1 : this.booking.getNumPatrons().intValue(), tableGroup, this.booking.getNotes());
            OrderMate.LOG.info("Making new Reservation for " + this.booking.getProvId());
        } else {
            String prepaymentComment;
            if (res.getCustomer() == null) {
                res.setCustomer(customer);
            }
            res.setDate(datePart);
            res.setTime(timePart);
            res.setNumPatrons(this.booking.getNumPatrons() == null ? res.getNumPatrons() : Integer.valueOf(this.booking.getNumPatrons().intValue()));
            res.setComments(null);
            if (!StringUtils.isEmpty(this.booking.getNotes())) {
                res.setComments(this.booking.getNotes());
            }
            if (!(prepaymentComment = this.buildPrepaymentComments(this.booking)).equals("")) {
                if (res.getComments() != null) {
                    res.setComments(res.getComments() + prepaymentComment);
                } else {
                    res.setComments(prepaymentComment);
                }
            }
            res.setSection(tableGroup);
        }
        if (!StringUtils.isEmpty(this.booking.getProvId())) {
            res.setExternalId(this.booking.getProvId());
        }
        if (this.booking.getDuration() != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(DateTimeUtils.mergeDateAndTime(datePart, timePart));
            cal.add(12, this.booking.getDuration().intValue());
            res.setLeaveTime(cal.getTime());
        }
        this.determineState(res, this.booking);
        res.save();
        if (!this.booking.getPayments().isEmpty()) {
            for (DiamondBookingPayment payment : this.booking.getPayments()) {
                if (!StringUtils.isEmpty(payment.getTxnRef())) {
                    ReservationDeposit resDeposit = new ReservationDeposit(payment);
                    res.getDeposits().add(resDeposit);
                    continue;
                }
                OrderMate.LOG.warn("Will not auto-apply deposit without a transaction reference");
            }
            res.save();
        }
        if (res.getTableAccount() == null) {
            if (!this.booking.getTables().isEmpty()) {
                res.setTables(StringUtils.mergeToStringWithSeparator(this.booking.getTables(), ",", null));
                res.save();
            }
            if ("ARRIVED".equals(res.getReservationState())) {
                new DiamondBackReservationArriver(res, this.booking).start();
            }
        } else if (!this.booking.getTables().isEmpty() && res.getTableAccount().isOpen() && this.booking.getState() != DiamondBookingState.CLOSING && this.booking.getState() != DiamondBookingState.CLOSED) {
            new DiamondBackReservationTransfer(res, this.booking).start();
        }
    }

    private String buildPrepaymentComments(DiamondBooking dbBooking) {
        String prepaymentComment = "";
        if (!dbBooking.getPayments().isEmpty()) {
            for (DiamondBookingPayment payment : dbBooking.getPayments()) {
                String thirdParty = payment.getIssuer();
                if (thirdParty == null || payment.getAmountPaid() == null) continue;
                prepaymentComment = prepaymentComment + " A deposit from " + thirdParty + " : $ " + payment.getAmountPaid().toString() + " has been added to this table";
            }
        }
        return prepaymentComment;
    }

    private TableGroup determineTableGroup(List<String> tables) {
        List<PhysicalTable> phTables = PersistenceManager.getObjectList(PhysicalTable.class, Query.select(PhysicalTable.class).wherePropertyIn(PhysicalTable.Properties.NAME, tables).active(PhysicalTable.class).toString());
        for (PhysicalTable phTable : phTables) {
            if (phTable.getLogicalTable() == null || !phTable.getLogicalTable().canOrderTo() || phTable.getLogicalTable().getTableGroup().isOnline()) continue;
            return phTable.getLogicalTable().getTableGroup();
        }
        return null;
    }

    protected void determineState(Reservation res, DiamondBooking booking) {
        if (booking.getState() == null) {
            return;
        }
        String newState = res.getReservationState();
        switch (booking.getState()) {
            case BOOKED: {
                newState = "BOOKED";
                break;
            }
            case CONFIRMED: {
                newState = "CONFIRMED";
                break;
            }
            case ARRIVED: {
                newState = "ARRIVED";
                break;
            }
            case CLOSING: {
                newState = "ARRIVED";
                break;
            }
            case CANCELLED: {
                newState = null;
                break;
            }
        }
        if (newState == null) {
            res.deleteReservation();
        } else if (!"ARRIVED".equals(res.getReservationState())) {
            res.setReservationState(newState);
        }
    }
}

