/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.diamondback;

import au.com.diamondback.xmlintegration.booking.DiamondBooking;
import au.com.diamondback.xmlintegration.booking.DiamondBookingPayment;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.StringUtils;
import java.util.Collections;
import java.util.Comparator;
import ordermate.OrderMate;
import ordermate.database.queries.tables.PhysicalTableQueries;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.reservation.Reservation;
import ordermate.database.sales.reservation.ReservationDeposit;
import ordermate.database.tables.PhysicalTable;
import ordermate.database.tables.TableGroup;
import ordermate.integration.diamondback.DiamondBackIntegrator;
import ordermate.integration.reservations.HeadlessReservationArriver;
import ordermate.webresource.diamondback.DiamondBackWorker;

public class DiamondBackReservationArriver
extends DiamondBackWorker {
    private final Reservation res;
    private final DiamondBooking dbBooking;

    public DiamondBackReservationArriver(Reservation res, DiamondBooking dbBooking) {
        this.res = res;
        this.dbBooking = dbBooking;
    }

    @Override
    protected String getName() {
        return "DB-Arrive-" + this.res.getID();
    }

    @Override
    protected boolean validate() {
        Reservation resReacquired = (Reservation)PersistenceManager.reacquire(this.res);
        return resReacquired.getTableAccount() == null;
    }

    @Override
    protected boolean performWork() {
        OrderMate.LOG.info("Auto-arriving DB booking " + this.res.getID());
        DBReservationArriver arriver = new DBReservationArriver(this.res);
        arriver.setArriveUnallocatedAllowed(true);
        arriver.arriveParty();
        this.res.save();
        try {
            DiamondBackIntegrator.getInstance().reservationUpdated(this.res);
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Cannot send reservation to diamondback", (Throwable)ex);
        }
        return true;
    }

    class DBReservationArriver
    extends HeadlessReservationArriver {
        DBReservationArriver(Reservation reservation) {
            super(reservation);
        }

        @Override
        protected void modifyArrivedAccount(TableAccount toModify) {
            if (!DiamondBackReservationArriver.this.dbBooking.getPayments().isEmpty()) {
                for (DiamondBookingPayment payment : DiamondBackReservationArriver.this.dbBooking.getPayments()) {
                    String txnRef = payment.getTxnRef();
                    if (txnRef == null) {
                        OrderMate.LOG.warn("Will not auto-apply deposit without a transaction reference");
                        continue;
                    }
                    ReservationDeposit resDeposit = new ReservationDeposit(payment);
                    boolean found = false;
                    for (ReservationDeposit deposit : DiamondBackReservationArriver.this.res.getDeposits()) {
                        if (!deposit.getTxnRef().equals(resDeposit.getTxnRef())) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    DiamondBackReservationArriver.this.res.getDeposits().add(resDeposit);
                    DiamondBackReservationArriver.this.res.save();
                }
            }
            super.modifyArrivedAccount(toModify);
        }

        @Override
        protected void getRequestedTable() {
            String tables = this.reservation.getTables();
            TableGroup section = this.reservation.getSection();
            if (StringUtils.isEmpty(tables)) {
                return;
            }
            if (this.reservation.getSection() != null) {
                this.physicalTables = PhysicalTableQueries.getPhysicalTables(tables, this.reservation.getSection());
            }
            if (this.physicalTables == null || this.physicalTables.isEmpty()) {
                this.physicalTables = PhysicalTableQueries.getPhysicalTables(tables, null);
            }
            if (!this.physicalTables.isEmpty()) {
                if (this.physicalTables.size() > 1) {
                    Collections.sort(this.physicalTables, new Comparator<PhysicalTable>(){

                        @Override
                        public int compare(PhysicalTable o1, PhysicalTable o2) {
                            if (o1 == null || o1.getLogicalTable() == null) {
                                if (o2 == null || o2.getLogicalTable() == null) {
                                    return 0;
                                }
                                return 1;
                            }
                            if (o2 == null || o2.getLogicalTable() == null) {
                                return -1;
                            }
                            if (o1.getLogicalTable().getTableGroup() == null) {
                                if (o2.getLogicalTable().getTableGroup() == null) {
                                    return 0;
                                }
                                return 1;
                            }
                            if (o2.getLogicalTable().getTableGroup() != null) {
                                return o1.getLogicalTable().getTableGroup().getSequence() - o2.getLogicalTable().getTableGroup().getSequence();
                            }
                            return 0;
                        }
                    });
                }
                try {
                    this.table = this.findFirstFreeTable(this.physicalTables);
                }
                catch (Exception ex) {
                    OrderMate.LOG.warn("Problem finding free table", (Throwable)ex);
                }
                if (this.table != null) {
                    OrderMate.LOG.info("Found physical table:" + this.table.getTableGroup().getLabel() + " " + this.table.getLabel());
                } else {
                    OrderMate.LOG.warn("Could not find free table " + this.getReservationInfo());
                }
            } else {
                this.logMessage("DiamondBack - Cannot find table! " + this.getReservationInfo());
                this.utils.displayTableDoesntExist(tables, section);
            }
        }
    }
}

