/*
 * Decompiled with CFR 0.152.
 */
package ordermate.webresource.diamondback;

import au.com.diamondback.xmlintegration.booking.DiamondBooking;
import au.com.ordermate.gui.DummyGUIHandler;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.Stringifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Semaphore;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.Lockable;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountState;
import ordermate.database.sales.SimplePrintAccount;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.reservation.Reservation;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.PhysicalTable;
import ordermate.database.tables.TableGroup;
import ordermate.database.tables.TableGroupHelper;
import ordermate.database.users.User;
import ordermate.gui.SimpleSaveAccount;
import ordermate.webresource.diamondback.DiamondBackWorker;
import org.apache.logging.log4j.Level;

class DiamondBackReservationTransfer
extends DiamondBackWorker {
    private static Semaphore talkingStick = new Semaphore(1);
    private final Reservation res;
    private final String section;
    private final List<String> requiredTables;
    private List<PhysicalTable> phTables;
    private List<Lockable> lockables;
    private Boolean success = null;
    private boolean arrangeOnJoin = true;

    DiamondBackReservationTransfer(Reservation toTransfer, DiamondBooking dbBooking) {
        this.res = toTransfer;
        this.section = dbBooking.getTableSection();
        this.requiredTables = dbBooking.getTables();
        this.arrangeOnJoin = Terminal.getServerMateTerminal().getGtl().isArrangeOnJoin();
    }

    @Override
    protected boolean validate() {
        if (this.requiredTables.isEmpty()) {
            return false;
        }
        String reqTables = StringUtils.mergeToStringWithSeparator(this.requiredTables, ",", null);
        if (((TableAccount)this.res.getTableAccount()).getTable() == null) {
            OrderMate.LOG.info("Reservation is currently on unallocated table, will transfer to " + reqTables);
            return true;
        }
        List<PhysicalTable> currentTables = ((TableAccount)this.res.getTableAccount()).getTable().getPhysicalTables();
        if (this.requiredTables.size() == currentTables.size()) {
            for (PhysicalTable table : currentTables) {
                if (this.requiredTables.contains(table.getName())) continue;
                OrderMate.LOG.info("Reservation is currently on " + this.res.getTables() + " will transfer to " + reqTables);
                return true;
            }
            OrderMate.LOG.info("Reservation is currently on " + this.res.getTables() + " will *not* transfer to " + reqTables);
            return false;
        }
        OrderMate.LOG.info("Reservation is currently on " + this.res.getTables() + " will transfer to " + reqTables);
        return true;
    }

    private void unlockEverything() {
        try {
            for (Lockable lockable : this.lockables) {
                lockable.unlock();
            }
        }
        finally {
            talkingStick.release();
        }
    }

    @Override
    protected boolean performWork() {
        OrderMate.LOG.info("Attempting to adjust tables for " + this.res);
        if (!this.lockEverything()) {
            return false;
        }
        try {
            TableAccount tableAccount = (TableAccount)this.res.getTableAccount();
            if (tableAccount.getTable() == null) {
                this.doAssignTable();
            } else if (this.phTables.contains(tableAccount.getTable().getPrimaryPhysicalTable())) {
                this.doRearrangeTables();
            } else {
                this.doTransferTable();
            }
            if (tableAccount.getTable() != null) {
                this.res.setSection(tableAccount.getTable().getTableGroup());
                this.res.setTables(StringUtils.mergeToStringWithSeparator(tableAccount.getTable().getPhysicalTables(), ",", new Stringifier<PhysicalTable>(){

                    @Override
                    public String stringify(PhysicalTable object) {
                        return object.getName();
                    }
                }));
                this.res.save();
                this.success = Boolean.TRUE;
            } else {
                this.success = Boolean.FALSE;
            }
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Cannot transfer reservations", (Throwable)ex);
            this.success = Boolean.FALSE;
        }
        finally {
            this.unlockEverything();
        }
        return true;
    }

    private void doTransferTable() {
        LogicalTable currentTable;
        if (this.phTables.isEmpty()) {
            OrderMate.LOG.warn("Cannot perform transfer for reservation " + this.res + " tables " + this.res.getTables());
            return;
        }
        TableAccount tableAccount = (TableAccount)PersistenceManager.reacquire((TableAccount)this.res.getTableAccount());
        PhysicalTable xferToPhTable = this.phTables.get(0);
        LogicalTable xferToLogTable = null;
        block0: for (PhysicalTable xferToPhTablei : this.phTables) {
            for (Lockable lockable : this.lockables) {
                if (!(lockable instanceof LogicalTable) || !((LogicalTable)lockable).getPrimaryPhysicalTable().equals(xferToPhTablei)) continue;
                xferToLogTable = (LogicalTable)lockable;
                xferToPhTable = xferToPhTablei;
                continue block0;
            }
        }
        if (tableAccount.getTable() != null && tableAccount.getTable().getPhysicalTables().contains(xferToPhTable) && (currentTable = tableAccount.getTable()) != null) {
            TableGroupHelper helper = currentTable.getTableGroup().getHelper();
            ArrayList<PhysicalTable> tables = new ArrayList<PhysicalTable>(currentTable.getPhysicalTables());
            tables.remove(currentTable.getPrimaryPhysicalTable());
            for (PhysicalTable nextTable : this.phTables) {
                if (!tables.contains(nextTable)) continue;
                LogicalTable newLogTable = helper.splitTable(currentTable, nextTable, this.arrangeOnJoin);
                if (xferToLogTable != null) continue;
                xferToLogTable = newLogTable;
            }
        }
        if (xferToLogTable != null) {
            User user = User.getSystemUser();
            OrderMate.LOG.info("Performing booking table transfer " + xferToLogTable.getLabel());
            TableAccount newAccount = new TableAccount(user, xferToLogTable, this.res.getNumPatrons() == null ? tableAccount.getNumPatrons() : this.res.getNumPatrons().intValue(), tableAccount.getEventContext().getTerminal());
            this.tryLock(newAccount, user);
            SimpleSaveAccount saveAccount = new SimpleSaveAccount(new DummyGUIHandler(), new SimplePrintAccount());
            this.res.setTableAccount(newAccount);
            List<FinanceTransaction> list = tableAccount.getFinanceTransactions();
            for (FinanceTransaction txn : list) {
                newAccount.addFinanceTransaction(txn.transfer());
            }
            saveAccount.performTransfer(tableAccount, newAccount, tableAccount.getAllItems(), new EventContext(Terminal.getServerMateTerminal(), user));
            this.res.save();
            if (this.requiredTables.size() > 1 && this.requiredTables.size() != xferToLogTable.getPhysicalTables().size()) {
                this.doRearrangeTables();
            }
        } else {
            OrderMate.LOG.warn("Cannot perform transfer for table " + xferToPhTable);
        }
    }

    private void doAssignTable() {
        if (this.phTables.isEmpty()) {
            OrderMate.LOG.warn("Cannot assign unassigned table account - no available tables for " + Arrays.toString(this.requiredTables.toArray()));
            return;
        }
        OrderMate.LOG.warn("Assigning unassigned table account");
        TableAccount tableAccount = (TableAccount)this.res.getTableAccount();
        tableAccount = (TableAccount)PersistenceManager.reacquire(tableAccount);
        boolean found = false;
        for (PhysicalTable nextTable : this.phTables) {
            if (nextTable.getLogicalTable().getAccount() != null) continue;
            tableAccount.setTable(nextTable.getLogicalTable());
            found = true;
            break;
        }
        if (found) {
            this.tryLock(tableAccount, User.getSystemUser());
            tableAccount.save();
        }
        if (this.requiredTables.size() > 1 && this.requiredTables.size() != tableAccount.getTable().getPhysicalTables().size()) {
            this.doRearrangeTables();
        }
    }

    private void doRearrangeTables() {
        LogicalTable nextLogTable;
        TableAccount tableAccount = (TableAccount)PersistenceManager.reacquire((TableAccount)this.res.getTableAccount());
        LogicalTable logTable = tableAccount.getTable();
        ArrayList<PhysicalTable> actualTables = new ArrayList<PhysicalTable>(logTable.getPhysicalTables());
        PhysicalTable primaryTable = logTable.getPrimaryPhysicalTable();
        TableGroupHelper helper = logTable.getTableGroup().getHelper();
        for (PhysicalTable nextTable : actualTables) {
            if (primaryTable == nextTable || this.phTables.contains(nextTable)) continue;
            try {
                helper.splitTable(logTable, nextTable, this.arrangeOnJoin);
            }
            catch (Exception ex) {
                OrderMate.LOG.warn("Cannot split off table for rearranging ", (Throwable)ex);
            }
        }
        for (PhysicalTable nextPhTable : this.phTables) {
            if (nextPhTable.equals((nextLogTable = nextPhTable.getLogicalTable()).getPrimaryPhysicalTable())) continue;
            try {
                helper.splitTable(nextLogTable, nextPhTable, this.arrangeOnJoin);
            }
            catch (Exception ex) {
                OrderMate.LOG.warn("split table warning just happened when there is intersection between orignal tables and new tables ", (Throwable)ex);
            }
        }
        for (PhysicalTable nextPhTable : this.phTables) {
            nextLogTable = nextPhTable.getLogicalTable();
            ArrayList<PhysicalTable> subTables = new ArrayList<PhysicalTable>(nextLogTable.getPhysicalTables());
            for (PhysicalTable subTable : subTables) {
                if (subTable.equals(nextLogTable.getPrimaryPhysicalTable()) || this.phTables.contains(subTable)) continue;
                helper.splitTable(nextLogTable, subTable, this.arrangeOnJoin);
            }
        }
        logTable.unlock();
        HashSet<LogicalTable> toAdd = new HashSet<LogicalTable>();
        for (PhysicalTable phTable : this.phTables) {
            PhysicalTable reacquired = (PhysicalTable)PersistenceManager.reacquire(phTable);
            if ((reacquired == primaryTable || reacquired.getLogicalTable().equals(logTable)) && logTable.getPhysicalTables().contains(reacquired)) continue;
            toAdd.add(reacquired.getLogicalTable());
        }
        toAdd.remove(logTable);
        for (LogicalTable table : toAdd) {
            table.unlock();
            LogicalTable mainTable = helper.joinTables(logTable, table, this.arrangeOnJoin);
            if (mainTable == null) continue;
            mainTable.saveChild();
        }
    }

    private boolean lockEverything() {
        if (talkingStick.tryAcquire()) {
            this.lockables = new ArrayList<Lockable>();
            User user = User.getSystemUser();
            try {
                TableAccount account = (TableAccount)this.res.getTableAccount();
                account = (TableAccount)PersistenceManager.reacquire(account);
                this.derivePhysicalTables();
                for (PhysicalTable table : this.phTables) {
                    if (table.getLogicalTable().getAccount() != null) continue;
                    this.tryLock(table.getLogicalTable(), user);
                }
                this.tryLock(account, user);
            }
            catch (Exception ex) {
                this.unlockEverything();
                return false;
            }
            return true;
        }
        return false;
    }

    private void derivePhysicalTables() {
        PhysicalTable mainTable = null;
        this.phTables = new ArrayList<PhysicalTable>();
        block0: for (String nextName : this.requiredTables) {
            ObjectQuery query = Query.select(PhysicalTable.class).linkUsing(PhysicalTable.Properties.LOGICAL_TABLE).linkUsing(LogicalTable.Properties.TABLE_GROUP).equals(PhysicalTable.Properties.NAME, nextName.trim()).equals(PhysicalTable.Properties.CAN_ORDER_TO, Boolean.TRUE).equals((PropertiedObject.Property)TableGroup.Properties.ONLINE, Boolean.FALSE).active(TableGroup.class).active(LogicalTable.class).active(PhysicalTable.class);
            if (!StringUtils.isEmpty(this.section)) {
                TableGroup theSection = PersistenceManager.getObject(TableGroup.class, Query.select(TableGroup.class).equals(TableGroup.Properties.NAME, this.section).equals(TableGroup.Properties.SYSTEM_STATE, "ACTIVE").equals((PropertiedObject.Property)TableGroup.Properties.ONLINE, Boolean.FALSE).toString());
                if (theSection != null) {
                    query.equals(LogicalTable.Properties.TABLE_GROUP, theSection);
                } else {
                    OrderMate.LOG.log(Level.WARN, "No section for desired transfer " + this.section);
                }
            }
            List<PhysicalTable> nextTables = PersistenceManager.getObjectList(PhysicalTable.class, query.toString());
            for (PhysicalTable nextTable : nextTables) {
                if (nextTable == null || this.phTables.contains(nextTable)) continue;
                if (mainTable == null) {
                    mainTable = nextTable;
                    this.phTables.add(nextTable);
                    continue block0;
                }
                if (!mainTable.getLogicalTable().getTableGroup().equals(nextTable.getLogicalTable().getTableGroup())) continue block0;
                this.phTables.add(nextTable);
                continue block0;
            }
        }
        Account account = this.res.getTableAccount();
        for (PhysicalTable nextTable : new ArrayList<PhysicalTable>(this.phTables)) {
            Account accountInDB;
            if (nextTable.getLogicalTable().getAccount() == null || (accountInDB = PersistenceManager.getObject(Account.class, Query.select(Account.class).equals(Account.Properties.ID, nextTable.getLogicalTable().getAccount().getID()).equals(Account.Properties.ACCOUNT_STATE, (Object)AccountState.OPEN).toString())) == null || account.equals(nextTable.getLogicalTable().getAccount())) continue;
            this.phTables.remove(nextTable);
        }
    }

    private void tryLock(Lockable lockable, User user) {
        if (!lockable.isLocked(user) && !lockable.lock(user)) {
            throw new IllegalStateException("Unable to lock " + lockable);
        }
        this.lockables.add(lockable);
    }

    Boolean getSuccess() {
        return this.success;
    }

    @Override
    protected String getName() {
        return "DB-Xfer-" + this.res.getID();
    }
}

